/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api.groups.impl;

import com.atlassian.fugue.Option;
import com.atlassian.hipchat.api.ClientResponseMapper;
import com.atlassian.hipchat.api.HipChatAPI;
import com.atlassian.hipchat.api.HipChatRoutesProvider;
import com.atlassian.hipchat.api.ResourceMapper;
import com.atlassian.hipchat.api.Result;
import com.atlassian.hipchat.api.groups.ExpandedGroup;
import com.atlassian.hipchat.api.groups.ExpandedGroupStatistics;
import com.atlassian.hipchat.api.groups.GroupService;
import com.atlassian.hipchat.api.groups.impl.Group;
import com.atlassian.util.concurrent.Promise;
import com.sun.jersey.api.client.Client;

public class DefaultGroupService<T extends HipChatAPI.TokenType>
implements GroupService {
    private final HipChatRoutesProvider.Routes<T> routes;
    private final Client client;
    private final ClientResponseMapper mapper;

    public DefaultGroupService(HipChatRoutesProvider.Routes<T> routes, Client client, ClientResponseMapper mapper) {
        this.routes = routes;
        this.client = client;
        this.mapper = mapper;
    }

    @Override
    public Promise<Result<ExpandedGroup>> getGroup(String groupId, Option<String> expansions) {
        return this.routes.getGroup(groupId, expansions).flatMap(ResourceMapper.toGetAsyncJsonResource(this.client)).map(this.mapper.to(Group.class)).recover(ResourceMapper.handleError());
    }

    @Override
    public Promise<Result<ExpandedGroupStatistics>> getGroupStatistics(String groupId) {
        return this.routes.getGroupStatistics(groupId).flatMap(ResourceMapper.toGetAsyncJsonResource(this.client)).map(this.mapper.to(ExpandedGroupStatistics.class)).recover(ResourceMapper.handleError());
    }
}

