/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api.connect.descriptor;

import com.atlassian.hipchat.api.connect.descriptor.HipChatCapability;
import java.net.URI;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Installable
implements HipChatCapability {
    private final URI installedUrl;
    private final URI uninstalledUrl;
    private final boolean allowRoom;
    private final boolean allowGlobal;

    @JsonCreator
    public Installable(@JsonProperty(value="installedUrl") URI installedUrl, @JsonProperty(value="uninstalledUrl") URI uninstalledUrl, @JsonProperty(value="allowRoom") boolean allowRoom, @JsonProperty(value="allowGlobal") boolean allowGlobal) {
        this.installedUrl = installedUrl;
        this.uninstalledUrl = uninstalledUrl;
        this.allowRoom = allowRoom;
        this.allowGlobal = allowGlobal;
    }

    public Installable(URI installedUrl, URI uninstalledUrl) {
        this.installedUrl = installedUrl;
        this.uninstalledUrl = uninstalledUrl;
        this.allowRoom = true;
        this.allowGlobal = true;
    }

    public URI getInstalledUrl() {
        return this.installedUrl;
    }

    public URI getUninstalledUrl() {
        return this.uninstalledUrl;
    }

    public boolean isAllowRoom() {
        return this.allowRoom;
    }

    public boolean isAllowGlobal() {
        return this.allowGlobal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Installable)) {
            return false;
        }
        Installable that = (Installable)o;
        if (this.allowGlobal != that.allowGlobal) {
            return false;
        }
        if (this.allowRoom != that.allowRoom) {
            return false;
        }
        if (this.installedUrl != null ? !this.installedUrl.equals(that.installedUrl) : that.installedUrl != null) {
            return false;
        }
        return !(this.uninstalledUrl != null ? !this.uninstalledUrl.equals(that.uninstalledUrl) : that.uninstalledUrl != null);
    }

    public int hashCode() {
        int result = this.installedUrl != null ? this.installedUrl.hashCode() : 0;
        result = 31 * result + (this.uninstalledUrl != null ? this.uninstalledUrl.hashCode() : 0);
        result = 31 * result + (this.allowRoom ? 1 : 0);
        result = 31 * result + (this.allowGlobal ? 1 : 0);
        return result;
    }

    public String toString() {
        return "Installable{installedUrl='" + this.installedUrl + '\'' + ", uninstalledUrl=" + this.uninstalledUrl + ", allowRoom=" + this.allowRoom + ", allowGlobal=" + this.allowGlobal + '}';
    }
}

