/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api;

import com.atlassian.fugue.Option;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonValue;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;

public enum HipChatScope {
    SendNotification("send_notification"),
    SendMessage("send_message"),
    AdminGroup("admin_group"),
    AdminRoom("admin_room"),
    ViewGroup("view_group"),
    ManageRooms("manage_rooms"),
    ViewMessages("view_messages");

    private final String scopeName;
    public static final HipChatScope[] EMPTY_SCOPES_ARRAY;
    public static final Set<HipChatScope> EMPTY_SCOPES_SET;
    private static final Map<String, HipChatScope> mapping;

    private HipChatScope(String scopeName) {
        this.scopeName = scopeName;
    }

    @JsonCreator
    public static HipChatScope parseHipChatScope(String scopeName) {
        HipChatScope hipChatScope = mapping.get(scopeName);
        return hipChatScope;
    }

    @JsonValue
    public String getScopeName() {
        return this.scopeName;
    }

    public String toString() {
        return this.getScopeName();
    }

    public static Option<HipChatScope> fromName(String name) {
        return Option.option((Object)((Object)mapping.get(name)));
    }

    static {
        EMPTY_SCOPES_ARRAY = new HipChatScope[0];
        EMPTY_SCOPES_SET = Collections.emptySet();
        mapping = new TreeMap<String, HipChatScope>();
        for (HipChatScope hipChatScope : HipChatScope.values()) {
            mapping.put(hipChatScope.getScopeName(), hipChatScope);
        }
    }

    public static class HipChatScopeSerializer
    extends JsonSerializer<HipChatScope> {
        public void serialize(HipChatScope value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.getScopeName());
        }
    }
}

