/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.beehive.compat;

import com.atlassian.beehive.compat.ClusterLockService;
import com.atlassian.beehive.compat.ClusterLockServiceAccessor;
import com.atlassian.beehive.compat.ClusterLockServiceServiceFactory;
import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public abstract class AbstractClusterLockServiceAccessor
implements ClusterLockServiceAccessor {
    private static final Logger log = LoggerFactory.getLogger(AbstractClusterLockServiceAccessor.class);
    private final ApplicationContext applicationContext;
    private ClusterLockService lockService;

    public AbstractClusterLockServiceAccessor(ApplicationContext applicationContext) {
        this.applicationContext = (ApplicationContext)Preconditions.checkNotNull((Object)applicationContext, (Object)"applicationContext");
    }

    @Override
    public synchronized ClusterLockService getClusterLockService() {
        if (this.lockService == null) {
            this.initLockService();
        }
        return this.lockService;
    }

    private void initLockService() {
        try {
            Class<?> factoryClass = this.getFactoryClass();
            if (factoryClass != null) {
                this.lockService = ((ClusterLockServiceServiceFactory)this.applicationContext.getAutowireCapableBeanFactory().createBean(factoryClass, 3, false)).get();
            }
        }
        catch (Exception e) {
            log.debug("Could not create " + this.getClusterLockServiceServiceFactoryClassName(), (Throwable)e);
        }
    }

    private Class<?> getFactoryClass() {
        try {
            this.getClass().getClassLoader().loadClass(this.getDependentClassName());
            return this.getClass().getClassLoader().loadClass(this.getClusterLockServiceServiceFactoryClassName());
        }
        catch (Exception e) {
            log.info("The necessary " + this.getDependentClassName() + " class is unavailable.");
            return null;
        }
    }

    public abstract String getDependentClassName();

    public abstract String getClusterLockServiceServiceFactoryClassName();
}

