/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api.healthcheck;

import com.atlassian.hipchat.api.ClientResponseMapper;
import com.atlassian.hipchat.api.HipChatAPI;
import com.atlassian.hipchat.api.HipChatRoutesProvider;
import com.atlassian.hipchat.api.ResourceMapper;
import com.atlassian.hipchat.api.Result;
import com.atlassian.hipchat.api.healthcheck.HealthCheckResult;
import com.atlassian.hipchat.api.healthcheck.HealthCheckService;
import com.atlassian.util.concurrent.Promise;
import com.sun.jersey.api.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHealthCheckService<T extends HipChatAPI.TokenType>
implements HealthCheckService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHealthCheckService.class);
    private final Client client;
    private final HipChatRoutesProvider.Routes<T> routes;
    private final ClientResponseMapper mapper;

    public DefaultHealthCheckService(Client client, HipChatRoutesProvider.Routes<T> routes, ClientResponseMapper mapper) {
        this.client = client;
        this.routes = routes;
        this.mapper = mapper;
    }

    @Override
    public Promise<Result<HealthCheckResult>> checkHealth() {
        return this.routes.getHealthCheck().flatMap(ResourceMapper.toGetAsyncJsonResource(this.client)).map(this.mapper.to(HealthCheckResult.class)).recover(ResourceMapper.handleError());
    }
}

