/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api.connect.descriptor;

import com.atlassian.hipchat.api.connect.descriptor.Contracts;
import java.net.URI;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class Vendor {
    private final URI url;
    private final String name;

    @JsonCreator
    public Vendor(@JsonProperty(value="url") URI url, @JsonProperty(value="name") String name) {
        Contracts.checkNotNil(url, "url must not be nil");
        Contracts.checkNotNil(name, "name must not be nil");
        this.url = url;
        this.name = name;
    }

    public URI getUrl() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vendor vendor = (Vendor)o;
        if (!this.name.equals(vendor.name)) {
            return false;
        }
        return this.url.equals(vendor.url);
    }

    public int hashCode() {
        int result = this.url.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return "Vendor{url='" + this.url + '\'' + ", name=" + this.name + '}';
    }
}

