/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api.common;

import com.atlassian.hipchat.api.ClientResponseMapper;
import com.atlassian.hipchat.api.HipChatAPI;
import com.atlassian.hipchat.api.HipChatRoutesProvider;
import com.atlassian.hipchat.api.ResourceMapper;
import com.atlassian.hipchat.api.Result;
import com.atlassian.hipchat.api.common.FeatureService;
import com.atlassian.hipchat.api.common.Features;
import com.atlassian.util.concurrent.Promise;
import com.google.common.util.concurrent.SettableFuture;
import com.sun.jersey.api.client.AsyncWebResource;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFeatureService<T extends HipChatAPI.TokenType>
implements FeatureService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultFeatureService.class);
    private static final int TIMEOUT = 30;
    private final Client client;
    private final HipChatRoutesProvider.Routes<T> routes;
    private final ClientResponseMapper mapper;

    public DefaultFeatureService(ClientResponseMapper mapper, HipChatRoutesProvider.Routes<T> routes, Client client) {
        this.mapper = mapper;
        this.routes = routes;
        this.client = client;
    }

    @Override
    public Promise<Result<Features>> getFeatures() {
        SettableFuture future = SettableFuture.create();
        AsyncWebResource.Builder accept = this.client.asyncResource(this.routes.getFeatures()).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        accept.get(ResourceMapper.async((SettableFuture<ClientResponse>)future));
        return ResourceMapper.forFuture(future).map(this.mapper.to(Features.class)).recover(ResourceMapper.handleError());
    }

    @Override
    public boolean isBtf() {
        Promise<Result<Features>> features = this.getFeatures();
        try {
            Result result = (Result)features.get(30L, TimeUnit.SECONDS);
            if (result.isSuccess()) {
                return ((Features)result.success()).isBtf();
            }
        }
        catch (Exception e) {
            logger.error("Failed to get the features from Hipchat. Error: ", (Throwable)e);
        }
        return false;
    }
}

