/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.avatar;

import com.atlassian.plugins.avatar.Avatar;
import com.atlassian.plugins.avatar.AvatarOwner;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface AvatarProvider<T, I> {
    public Avatar getAvatar(String var1, int var2);

    public Avatar getAvatar(AvatarOwner<T> var1, int var2);

    public Avatar getAvatarById(I var1, int var2);

    public Avatar getAvatar(AvatarOwner<T> var1, Function<AvatarOwner<T>, Avatar> var2, int var3);

    default public <K, A> Map<K, Map<Integer, A>> getAvatarsForUsersAndSizes(Function<T, K> keyExtractor, Collection<AvatarOwner<T>> avatarOwners, List<Integer> sizes, Function<Avatar, A> toAvatarType) {
        return avatarOwners.stream().collect(Collectors.toMap(owner -> keyExtractor.apply(owner.get()), owner -> sizes.stream().collect(Collectors.toMap(size -> size, size -> toAvatarType.apply(this.getAvatar((AvatarOwner<T>)owner, (int)size))))));
    }
}

