package com.atlassian.plugins.avatar;

import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.descriptors.AbstractWebFragmentModuleDescriptor;
import io.atlassian.util.concurrent.ResettableLazyReference;

/**
 * Atlassian plugin system pluggability for providing Avatars. @see AvatarProvider
 */
@SuppressWarnings("UnusedDeclaration")
public class AvatarProviderModuleDescriptor extends AbstractWebFragmentModuleDescriptor<AvatarProvider>
        implements Comparable<AvatarProviderModuleDescriptor> {

    /**
     * Lazy reference to the avatar provider module
     */
    private final ResettableLazyReference<AvatarProvider> moduleReference = new ResettableLazyReference<AvatarProvider>() {
        @Override
        protected AvatarProvider create() throws Exception {
            return createModule();
        }
    };

    public AvatarProviderModuleDescriptor(ModuleFactory moduleCreator, DynamicWebInterfaceManager webInterfaceManager) {
        super(moduleCreator, webInterfaceManager);
    }

    /**
     * Create the avatar provider module
     *
     * @return the AvatarProvider
     */
    private AvatarProvider createModule() {
        final AvatarProvider module = moduleFactory.createModule(moduleClassName, this);
        return module;
    }

    /**
     * @return the AvatarProvider
     */
    public AvatarProvider getModule() {
        return moduleReference.get();
    }

    @Override
    public void enabled() {
        super.enabled();
        // Reset the reference if the module is enabled or disabled.
        // Don't actually know if this is necessary, but it copies the behavior of AbstractJiraModuleDescriptor
        // and can't hurt. AbstractJiraModuleDescriptor which does this to avoid issues with selenium tests, where
        // a plugin may be enabled twice.
        moduleReference.reset();
    }

    @Override
    public void disabled() {
        super.disabled();
        moduleReference.reset();
    }

    /**
     * Heaviest first.
     */
    public int compareTo(AvatarProviderModuleDescriptor otherDescriptor) {
        return otherDescriptor.weight - weight;
    }
}
