/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.web.oidc;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginDisablingEvent;
import com.atlassian.plugins.authentication.event.SsoConfigUpdatedEvent;
import com.atlassian.plugins.authentication.event.SsoDisabledEvent;
import com.atlassian.plugins.authentication.impl.config.SsoConfigService;
import com.atlassian.plugins.authentication.impl.config.oidc.OidcConfig;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.cron.CronSyntaxException;
import com.atlassian.scheduler.status.JobDetails;
import com.google.common.base.Strings;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class OidcDiscoveryRefreshJob {
    private static final String DEFAULT_CRON_EXPRESSION = "0 0 1 * * ?";
    private static final Duration COOLDOWN_PERIOD_AT_STARTUP = Duration.ofSeconds(10L);
    protected static final JobRunnerKey JOB_KEY = JobRunnerKey.of((String)(OidcDiscoveryRefreshJob.class.getName() + "-refresh"));
    private static final String REFRESH_JOB_NAME = "OidcDiscoveryRefresh";
    public static final JobId JOB_ID = JobId.of((String)"OidcDiscoveryRefresh");
    public static final JobId JOB_ID_FOR_SINGLE_RUN = JobId.of((String)"OidcDiscoveryRefresh:SingleRun");
    private static final Logger log = LoggerFactory.getLogger(OidcDiscoveryRefreshJob.class);
    private final SchedulerService schedulerService;
    private final SsoConfigService ssoConfigService;
    private final EventPublisher eventPublisher;

    @Inject
    public OidcDiscoveryRefreshJob(SchedulerService schedulerService, SsoConfigService ssoConfigService, EventPublisher eventPublisher) {
        this.schedulerService = schedulerService;
        this.ssoConfigService = ssoConfigService;
        this.eventPublisher = eventPublisher;
    }

    @PostConstruct
    public void register() throws SchedulerServiceException {
        this.schedulerService.registerJobRunner(JOB_KEY, this::updateConfig);
        this.eventPublisher.register((Object)this);
        this.reschedule();
        this.forceSingleRun(COOLDOWN_PERIOD_AT_STARTUP);
    }

    @PreDestroy
    public void unregister() {
        this.eventPublisher.unregister((Object)this);
        this.schedulerService.unregisterJobRunner(JOB_KEY);
    }

    private void forceSingleRun(@Nullable Duration delay) throws SchedulerServiceException {
        if (this.getDiscoveryConfig().isPresent()) {
            this.scheduleJob(JOB_ID_FOR_SINGLE_RUN, Schedule.runOnce(delay == null ? null : Date.from(Instant.now().plus(COOLDOWN_PERIOD_AT_STARTUP))));
        }
    }

    public void reschedule() throws SchedulerServiceException {
        Optional<String> cron = this.getDiscoveryConfig().map(OidcConfig::getDiscoveryRefreshCron).map(Strings::emptyToNull);
        if (cron.isPresent()) {
            try {
                this.scheduleJob(JOB_ID, Schedule.forCronExpression((String)cron.get()));
                return;
            }
            catch (CronSyntaxException e) {
                log.info("Invalid cron expression {}, falling back to default.", (Object)cron.get(), (Object)e);
            }
        }
        this.scheduleJob(JOB_ID, Schedule.forCronExpression((String)DEFAULT_CRON_EXPRESSION));
    }

    @VisibleForTesting
    protected JobRunnerResponse updateConfig(JobRunnerRequest request) {
        try {
            this.ssoConfigService.refreshSsoConfig();
            return JobRunnerResponse.success();
        }
        catch (Exception e) {
            log.warn("Refreshing OIDC discovery failed.", (Throwable)e);
            return JobRunnerResponse.failed((Throwable)e);
        }
    }

    private Optional<OidcConfig> getDiscoveryConfig() {
        return OidcConfig.from(this.ssoConfigService.getSsoConfig()).filter(OidcConfig::isDiscoveryEnabled);
    }

    private void stopJob() {
        log.info("Removing the job refreshing OIDC discovery config");
        this.schedulerService.getJobsByJobRunnerKey(JOB_KEY).stream().map(JobDetails::getJobId).peek(jobId -> log.debug("Unscheduling job '{}' since discovery is no longer used", jobId)).forEach(arg_0 -> ((SchedulerService)this.schedulerService).unscheduleJob(arg_0));
    }

    private void scheduleJob(JobId id, Schedule schedule) throws SchedulerServiceException {
        JobConfig config = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(schedule);
        Date nextRun = this.schedulerService.calculateNextRunTime(schedule);
        log.info("Scheduling job {} with next run time: '{}'.", (Object)id, (Object)nextRun);
        this.schedulerService.scheduleJob(id, config);
    }

    @EventListener
    public void onPluginDisablingEvent(PluginDisablingEvent event) {
        if ("com.atlassian.plugins.authentication.atlassian-authentication-plugin".equals(event.getPlugin())) {
            log.info("Authentication plugin was disabled, stopping OIDC discovery job.");
            this.stopJob();
        }
    }

    @EventListener
    public void onSsoConfigUpdatedEvent(SsoConfigUpdatedEvent event) {
        this.safeReschedule();
    }

    @EventListener
    public void onSsoDisabledEvent(SsoDisabledEvent event) {
        this.safeReschedule();
    }

    private void safeReschedule() {
        try {
            this.reschedule();
        }
        catch (Exception e) {
            log.error("Error while re-scheduling OpenID discovery refresh job", (Throwable)e);
        }
    }
}

