/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.web.filter.logout;

import com.atlassian.plugins.authentication.impl.config.SsoConfig;
import com.atlassian.plugins.authentication.impl.config.SsoConfigService;
import com.atlassian.plugins.authentication.impl.web.SessionDataService;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class LoggedOutFromServiceDeskFilter
implements Filter {
    private final SessionDataService sessionDataService;
    private final SsoConfigService ssoConfigService;

    @Inject
    public LoggedOutFromServiceDeskFilter(SessionDataService sessionDataService, SsoConfigService ssoConfigService) {
        this.sessionDataService = sessionDataService;
        this.ssoConfigService = ssoConfigService;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, response);
        SsoConfig ssoConfig = this.ssoConfigService.getSsoConfig();
        if (ssoConfig != null && ssoConfig.isRedirectOnLogin() && ssoConfig.isIncludeCustomerLogins()) {
            this.sessionDataService.setLoggedOutFromSdCustomerPortal((HttpServletRequest)request, true);
        }
    }

    public void destroy() {
    }
}

