/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.rest.model;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.plugins.authentication.impl.config.JustInTimeConfig;
import com.atlassian.plugins.authentication.impl.config.SsoConfig;
import com.atlassian.plugins.authentication.impl.config.SsoType;
import com.atlassian.plugins.authentication.impl.config.oidc.OidcConfig;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfig;
import java.util.List;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlElement;

public class SsoConfigEntity {
    @XmlElement(name="sso-type")
    private SsoType ssoType;
    @XmlElement(name="redirect-on-login")
    private Boolean redirectOnLogin;
    @XmlElement(name="allow-redirect-override")
    private Boolean allowRedirectOverride;
    @XmlElement(name="include-customer-logins")
    private Boolean includeCustomerLogins;
    @XmlElement(name="enable-remember-me")
    private Boolean enableRememberMe;
    @XmlElement(name="user-provisioning-enabled")
    private Boolean enableUserProvisioning;
    @XmlElement(name="idp-type")
    private SamlConfig.IdpType idpType;
    @XmlElement(name="sso-url")
    private String ssoUrl;
    @XmlElement(name="sso-issuer")
    private String ssoIssuer;
    @XmlElement(name="crowd-url")
    private String crowdUrl;
    @XmlElement(name="certificate")
    private String certificate;
    @XmlElement(name="user-attribute")
    private String userAttribute;
    @XmlElement(name="issuer-url")
    private String issuerUrl;
    @XmlElement(name="client-id")
    private String clientId;
    @XmlElement(name="client-secret")
    private String clientSecret;
    @XmlElement(name="authorization-endpoint")
    private String authorizationEndpoint;
    @XmlElement(name="token-endpoint")
    private String tokenEndpoint;
    @XmlElement(name="userinfo-endpoint")
    private String userInfoEndpoint;
    @XmlElement(name="discovery-enabled")
    private Boolean discoveryEnabled;
    @XmlElement(name="discovery-refresh-cron")
    private String discoveryRefreshCron;
    @XmlElement(name="additional-scopes")
    private List<String> additionalScopes;
    @XmlElement(name="username-claim")
    private String usernameClaim;
    @XmlElement(name="mapping-displayname")
    private String mappingDisplayName;
    @XmlElement(name="mapping-email")
    private String mappingEmail;
    @XmlElement(name="mapping-groups")
    private String mappingGroups;
    @XmlElement(name="additional-jit-scopes")
    private List<String> additionalJitScopes;

    private SsoConfigEntity() {
    }

    public SsoConfigEntity(@Nullable SsoConfig config) {
        if (config == null) {
            this.ssoType = SsoType.NONE;
        } else {
            this.ssoType = config.getSsoType();
            this.redirectOnLogin = config.isRedirectOnLogin();
            this.allowRedirectOverride = config.isAllowRedirectOverride();
            this.includeCustomerLogins = config.isIncludeCustomerLogins();
            this.enableRememberMe = config.isEnableRememberMe();
            if (config.getSsoType() == SsoType.SAML) {
                SamlConfig samlConfig = (SamlConfig)config;
                this.idpType = samlConfig.getIdpType();
                if (this.idpType == SamlConfig.IdpType.CROWD) {
                    this.crowdUrl = samlConfig.getSsoIssuer();
                } else {
                    this.ssoUrl = samlConfig.getSsoUrl();
                    this.ssoIssuer = samlConfig.getSsoIssuer();
                }
                this.certificate = samlConfig.getCertificate();
                this.userAttribute = samlConfig.getUsernameAttribute();
            } else if (config.getSsoType() == SsoType.OIDC) {
                OidcConfig oidcConfig = (OidcConfig)config;
                this.issuerUrl = oidcConfig.getIssuerUrl();
                this.clientId = oidcConfig.getClientId();
                if (!oidcConfig.isDiscoveryEnabled()) {
                    this.authorizationEndpoint = oidcConfig.getAuthorizationEndpoint();
                    this.tokenEndpoint = oidcConfig.getTokenEndpoint();
                    this.userInfoEndpoint = oidcConfig.getUserInfoEndpoint();
                }
                this.discoveryEnabled = oidcConfig.isDiscoveryEnabled();
                this.discoveryRefreshCron = oidcConfig.getDiscoveryRefreshCron();
                this.additionalScopes = oidcConfig.getAdditionalScopes();
                this.usernameClaim = oidcConfig.getUsernameClaim();
            }
            JustInTimeConfig justInTimeConfig = config.getJustInTimeConfig();
            this.enableUserProvisioning = justInTimeConfig.isEnabled().orElse(null);
            this.mappingDisplayName = justInTimeConfig.getDisplayNameMappingExpression().orElse(null);
            this.mappingEmail = justInTimeConfig.getEmailMappingExpression().orElse(null);
            this.mappingGroups = justInTimeConfig.getGroupsMappingSource().orElse(null);
            this.additionalJitScopes = justInTimeConfig.getAdditionalJitScopes();
        }
    }

    public SsoType getSsoType() {
        return this.ssoType;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public Boolean getRedirectOnLogin() {
        return this.redirectOnLogin;
    }

    public Boolean getAllowRedirectOverride() {
        return this.allowRedirectOverride;
    }

    public Boolean getIncludeCustomerLogins() {
        return this.includeCustomerLogins;
    }

    public Boolean getEnableRememberMe() {
        return this.enableRememberMe;
    }

    public SamlConfig.IdpType getIdpType() {
        return this.idpType;
    }

    public String getSsoUrl() {
        return this.ssoUrl;
    }

    public String getSsoIssuer() {
        return this.ssoIssuer;
    }

    public String getCrowdUrl() {
        return this.crowdUrl;
    }

    public String getUserAttribute() {
        return this.userAttribute;
    }

    public String getIssuerUrl() {
        return this.issuerUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public String getUserInfoEndpoint() {
        return this.userInfoEndpoint;
    }

    public Boolean getDiscoveryEnabled() {
        return this.discoveryEnabled;
    }

    public String getDiscoveryRefreshCron() {
        return this.discoveryRefreshCron;
    }

    public Boolean getEnableUserProvisioning() {
        return this.enableUserProvisioning;
    }

    public String getMappingDisplayName() {
        return this.mappingDisplayName;
    }

    public String getMappingEmail() {
        return this.mappingEmail;
    }

    public String getMappingGroups() {
        return this.mappingGroups;
    }

    @Nullable
    public List<String> getAdditionalJitScopes() {
        return this.additionalJitScopes;
    }

    @Nullable
    public List<String> getAdditionalScopes() {
        return this.additionalScopes;
    }

    public String getUsernameClaim() {
        return this.usernameClaim;
    }

    @VisibleForTesting
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @VisibleForTesting
    public void setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    @VisibleForTesting
    public void setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    @VisibleForTesting
    public void setUserInfoEndpoint(String userInfoEndpoint) {
        this.userInfoEndpoint = userInfoEndpoint;
    }

    public static interface Config {
        public static final String SSO_TYPE = "sso-type";
        public static final String REDIRECT_ON_LOGIN = "redirect-on-login";
        public static final String ALLOW_REDIRECT_OVERRIDE = "allow-redirect-override";
        public static final String INCLUDE_CUSTOMER_LOGINS = "include-customer-logins";
        public static final String ENABLE_REMEMBER_ME = "enable-remember-me";
        public static final String USER_PROVISIONING_ENABLED = "user-provisioning-enabled";
        public static final String MAPPING_DISPLAY_NAME = "mapping-displayname";
        public static final String MAPPING_EMAIL = "mapping-email";
        public static final String MAPPING_GROUPS = "mapping-groups";
        public static final String MAPPING_ADDITIONAL_JIT_SCOPES = "additional-jit-scopes";

        public static interface Oidc {
            public static final String ISSUER_URL = "issuer-url";
            public static final String CLIENT_ID = "client-id";
            public static final String CLIENT_SECRET = "client-secret";
            public static final String AUTHORIZATION_ENDPOINT = "authorization-endpoint";
            public static final String TOKEN_ENDPOINT = "token-endpoint";
            public static final String USER_INFO_ENDPOINT = "userinfo-endpoint";
            public static final String DISCOVERY_ENABLED = "discovery-enabled";
            public static final String DISCOVERY_REFRESH_CRON = "discovery-refresh-cron";
            public static final String ADDITIONAL_SCOPES = "additional-scopes";
            public static final String USERNAME_CLAIM = "username-claim";
        }

        public static interface Saml {
            public static final String IDP_TYPE = "idp-type";
            public static final String SSO_URL = "sso-url";
            public static final String SSO_ISSUER = "sso-issuer";
            public static final String CROWD_URL = "crowd-url";
            public static final String CERTIFICATE = "certificate";
            public static final String USER_ATTRIBUTE = "user-attribute";
        }
    }
}

