/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.web.usercontext.impl.jit.mapping;

import com.atlassian.plugins.authentication.impl.config.JustInTimeConfig;
import com.atlassian.plugins.authentication.impl.config.SsoConfigService;
import com.atlassian.plugins.authentication.impl.config.oidc.OidcConfig;
import com.atlassian.plugins.authentication.impl.web.usercontext.impl.jit.JitException;
import com.atlassian.plugins.authentication.impl.web.usercontext.impl.jit.mapping.JitUserData;
import com.atlassian.plugins.authentication.impl.web.usercontext.impl.jit.mapping.MappingExpression;
import com.google.common.collect.ImmutableSet;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import java.text.ParseException;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Named;

@Named
public class OidcUserDataFromIdpMapper {
    private final SsoConfigService ssoConfigService;

    public OidcUserDataFromIdpMapper(SsoConfigService ssoConfigService) {
        this.ssoConfigService = ssoConfigService;
    }

    public JitUserData mapUser(OIDCTokens tokens, String username) {
        try {
            OidcConfig oidcConfig = this.ssoConfigService.getOidcConfigOrFail();
            JustInTimeConfig justInTimeConfig = oidcConfig.getJustInTimeConfig();
            JWTClaimsSet jwtClaimsSet = tokens.getIDToken().getJWTClaimsSet();
            String subject = jwtClaimsSet.getSubject();
            if (subject == null) {
                throw new JitException("Subject not found");
            }
            String displayName = this.evaluateExpression(justInTimeConfig.getDisplayNameMappingExpression().orElseThrow(OidcUserDataFromIdpMapper.mappingConfigurationNotPresentException("display name")), jwtClaimsSet);
            String email = this.evaluateExpression(justInTimeConfig.getEmailMappingExpression().orElseThrow(OidcUserDataFromIdpMapper.mappingConfigurationNotPresentException("email")), jwtClaimsSet);
            ImmutableSet groups = ImmutableSet.copyOf(jwtClaimsSet.getStringListClaim(justInTimeConfig.getGroupsMappingSource().orElseThrow(OidcUserDataFromIdpMapper.mappingConfigurationNotPresentException("groups"))));
            return new JitUserData(subject, username, displayName, email, (Set<String>)groups);
        }
        catch (Exception e) {
            throw new JitException(e);
        }
    }

    private static Supplier<IllegalStateException> mappingConfigurationNotPresentException(String mappingKey) {
        return () -> new IllegalStateException("Configuration for " + mappingKey + " for OIDC is not set");
    }

    private String evaluateExpression(String rawExpression, JWTClaimsSet claims) {
        MappingExpression expression = new MappingExpression(rawExpression);
        return expression.evaluateWithValues(varName -> this.getStringClaimOrFail(claims, (String)varName));
    }

    private String getStringClaimOrFail(JWTClaimsSet claimSet, String claimName) {
        try {
            String claim = claimSet.getStringClaim(claimName);
            if (claim != null) {
                return claim;
            }
            throw new JitException(String.format("Claim [%s] could not be found", claimName));
        }
        catch (ParseException exception) {
            throw new JitException(String.format("Claim [%s] was not of type String", claimName));
        }
    }
}

