/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.config.oidc;

import com.atlassian.plugins.authentication.impl.config.JustInTimeConfig;
import com.atlassian.plugins.authentication.impl.config.SsoConfig;
import com.atlassian.plugins.authentication.impl.config.SsoType;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OidcConfig
extends SsoConfig {
    private final String clientId;
    private final String clientSecret;
    private final String issuerUrl;
    private final String authorizationEndpoint;
    private final String tokenEndpoint;
    private final String userInfoEndpoint;
    private final boolean discoveryEnabled;
    private final String discoveryRefreshCron;
    private final List<String> additionalScopes;
    private final String usernameClaim;

    private OidcConfig(boolean redirectOnLogin, boolean allowRedirectOverride, boolean includeCustomerLogins, boolean enableRememberMe, @Nonnull JustInTimeConfig justInTimeConfig, boolean discoveryEnabled, @Nonnull String clientId, @Nonnull String clientSecret, @Nonnull String issuerUrl, @Nullable String authorizationEndpoint, @Nullable String tokenEndpoint, @Nullable String userInfoEndpoint, @Nullable String discoveryRefreshCron, @Nonnull Iterable<String> additionalScopes, @Nullable String usernameClaim) {
        super(redirectOnLogin, allowRedirectOverride, includeCustomerLogins, enableRememberMe, justInTimeConfig);
        this.discoveryEnabled = discoveryEnabled;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.issuerUrl = issuerUrl;
        this.authorizationEndpoint = authorizationEndpoint;
        this.tokenEndpoint = tokenEndpoint;
        this.userInfoEndpoint = userInfoEndpoint;
        this.discoveryRefreshCron = discoveryRefreshCron;
        this.additionalScopes = ImmutableList.copyOf(additionalScopes);
        this.usernameClaim = usernameClaim;
    }

    @Override
    @Nonnull
    public SsoType getSsoType() {
        return SsoType.OIDC;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getIssuerUrl() {
        return this.issuerUrl;
    }

    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public String getUserInfoEndpoint() {
        return this.userInfoEndpoint;
    }

    public boolean isDiscoveryEnabled() {
        return this.discoveryEnabled;
    }

    public String getDiscoveryRefreshCron() {
        return this.discoveryRefreshCron;
    }

    @Nonnull
    public List<String> getAdditionalScopes() {
        return this.additionalScopes;
    }

    @Nullable
    public String getUsernameClaim() {
        return this.usernameClaim;
    }

    public static Optional<OidcConfig> from(SsoConfig config) {
        return config instanceof OidcConfig ? Optional.of((OidcConfig)config) : Optional.empty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OidcConfig that = (OidcConfig)o;
        return this.discoveryEnabled == that.discoveryEnabled && Objects.equals(this.clientId, that.clientId) && Objects.equals(this.clientSecret, that.clientSecret) && Objects.equals(this.issuerUrl, that.issuerUrl) && Objects.equals(this.authorizationEndpoint, that.authorizationEndpoint) && Objects.equals(this.tokenEndpoint, that.tokenEndpoint) && Objects.equals(this.userInfoEndpoint, that.userInfoEndpoint) && Objects.equals(this.discoveryRefreshCron, that.discoveryRefreshCron) && Objects.equals(this.additionalScopes, that.additionalScopes) && Objects.equals(this.usernameClaim, that.usernameClaim);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.clientId, this.clientSecret, this.issuerUrl, this.authorizationEndpoint, this.tokenEndpoint, this.userInfoEndpoint, this.discoveryEnabled, this.discoveryRefreshCron, this.additionalScopes, this.usernameClaim);
    }

    public String toString() {
        return "OidcConfig{clientId='" + this.clientId + '\'' + ", clientSecret='" + this.clientSecret + '\'' + ", issuerUrl='" + this.issuerUrl + '\'' + ", authorizationEndpoint='" + this.authorizationEndpoint + '\'' + ", tokenEndpoint='" + this.tokenEndpoint + '\'' + ", userInfoEndpoint='" + this.userInfoEndpoint + '\'' + ", discoveryEnabled=" + this.discoveryEnabled + ", discoveryRefreshCron='" + this.discoveryRefreshCron + '\'' + ", additionalScopes=" + this.additionalScopes + ", usernameClaim='" + this.usernameClaim + '\'' + '}';
    }

    @Override
    public Builder toBuilder() {
        return OidcConfig.builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(@Nonnull OidcConfig oidcConfig) {
        return new Builder(oidcConfig);
    }

    public static class Builder
    extends SsoConfig.Builder<Builder> {
        private String clientId;
        private String clientSecret;
        private String issuerUrl;
        private String authorizationEndpoint;
        private String tokenEndpoint;
        private String userInfoEndpoint;
        private boolean discoveryEnabled;
        private String discoveryRefreshCron;
        private List<String> additionalScopes = Collections.emptyList();
        private String usernameClaim;

        private Builder() {
        }

        private Builder(@Nonnull OidcConfig oidcConfig) {
            super(oidcConfig);
            this.clientId = oidcConfig.getClientId();
            this.clientSecret = oidcConfig.getClientSecret();
            this.issuerUrl = oidcConfig.getIssuerUrl();
            this.authorizationEndpoint = oidcConfig.getAuthorizationEndpoint();
            this.tokenEndpoint = oidcConfig.getTokenEndpoint();
            this.userInfoEndpoint = oidcConfig.getUserInfoEndpoint();
            this.discoveryEnabled = oidcConfig.isDiscoveryEnabled();
            this.discoveryRefreshCron = oidcConfig.getDiscoveryRefreshCron();
            this.additionalScopes = ImmutableList.copyOf(oidcConfig.getAdditionalScopes());
            this.usernameClaim = oidcConfig.getUsernameClaim();
            this.justInTimeConfig = oidcConfig.getJustInTimeConfig();
        }

        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public Builder setIssuerUrl(String issuerUrl) {
            this.issuerUrl = issuerUrl;
            return this;
        }

        public Builder setAuthorizationEndpoint(String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        public Builder setTokenEndpoint(String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        public Builder setUserInfoEndpoint(String userInfoEndpoint) {
            this.userInfoEndpoint = userInfoEndpoint;
            return this;
        }

        public Builder setDiscoveryEnabled(boolean discoveryEnabled) {
            this.discoveryEnabled = discoveryEnabled;
            return this;
        }

        public Builder setDiscoveryRefreshCron(String discoveryRefreshCron) {
            this.discoveryRefreshCron = discoveryRefreshCron;
            return this;
        }

        public Builder setAdditionalScopes(Iterable<String> additionalScopes) {
            this.additionalScopes = additionalScopes != null ? ImmutableList.copyOf(additionalScopes) : Collections.emptyList();
            return this;
        }

        public Builder setUsernameClaim(String usernameClaim) {
            this.usernameClaim = usernameClaim;
            return this;
        }

        @Override
        public Builder setJustInTimeConfig(JustInTimeConfig justInTimeConfig) {
            this.justInTimeConfig = justInTimeConfig;
            return this;
        }

        @Override
        @Nonnull
        public OidcConfig build() {
            return new OidcConfig(this.redirectOnLogin, this.allowRedirectOverride, this.includeCustomerLogins, this.enableRememberMe, this.justInTimeConfig, this.discoveryEnabled, this.clientId, this.clientSecret, this.issuerUrl, this.authorizationEndpoint, this.tokenEndpoint, this.userInfoEndpoint, this.discoveryRefreshCron, this.additionalScopes, this.usernameClaim);
        }
    }
}

