/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.analytics.events;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.plugins.authentication.impl.analytics.events.AbstractStatusEvent;
import com.atlassian.plugins.authentication.impl.config.SsoConfig;
import com.atlassian.plugins.authentication.impl.config.SsoType;
import com.atlassian.plugins.authentication.impl.config.oidc.OidcConfig;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfig;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdpProviderStatusEvent
extends AbstractStatusEvent {
    private static final Logger log = LoggerFactory.getLogger(IdpProviderStatusEvent.class);

    public IdpProviderStatusEvent(SsoConfig ssoConfig, String product) {
        super(ssoConfig, product);
    }

    private String getSsoTypeInfo() {
        SsoType ssoType = this.ssoConfig.getSsoType();
        switch (ssoType) {
            case SAML: {
                return "saml";
            }
            case OIDC: {
                return "oidc";
            }
        }
        throw new IllegalStateException("Unknown SSO type: " + (Object)((Object)this.ssoConfig.getSsoType()));
    }

    private String getIdpTypeInfo() {
        switch (this.ssoConfig.getSsoType()) {
            case SAML: {
                SamlConfig samlConfig = (SamlConfig)this.ssoConfig;
                return samlConfig.getInferredIdpType() == SamlConfig.IdpType.CROWD ? "crowd" : this.getIdpTypeInfoFromUrl(samlConfig.getSsoUrl());
            }
            case OIDC: {
                OidcConfig oidcConfig = (OidcConfig)this.ssoConfig;
                return this.getIdpTypeInfoFromUrl(oidcConfig.getIssuerUrl());
            }
        }
        throw new IllegalStateException("Unknown SSO type: " + (Object)((Object)this.ssoConfig.getSsoType()));
    }

    private String getIdpTypeInfoFromUrl(String url) {
        try {
            URI uri = new URI(url);
            if (uri.getHost().endsWith("onelogin.com")) {
                return "onelogin";
            }
            if (uri.getHost().endsWith("okta.com") || uri.getHost().endsWith("oktapreview.com")) {
                return "okta";
            }
            if (uri.getHost().endsWith("pingidentity.com")) {
                return "ping";
            }
            if (uri.getHost().endsWith("microsoft.com") || uri.getHost().endsWith("azure.com") || uri.getHost().endsWith("windows.net")) {
                return "azure";
            }
            if (uri.getHost().endsWith("google.com")) {
                return "google";
            }
            if (uri.getPath().startsWith("/adfs")) {
                return "adfs";
            }
        }
        catch (URISyntaxException e) {
            log.warn("Failed parsing SSO URL");
        }
        return "other";
    }

    @Override
    @EventName
    public String getEventName() {
        return String.format("plugins.authentication.status.%s.idp.%s", this.getSsoTypeInfo(), this.getIdpTypeInfo());
    }
}

