/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.analytics;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.impl.analytics.AbstractStatisticsCollectionService;
import com.atlassian.plugins.authentication.impl.analytics.NodeIdProvider;
import com.atlassian.plugins.authentication.impl.analytics.events.AuthenticationCountEvent;
import com.atlassian.plugins.authentication.impl.config.SsoConfigService;
import com.atlassian.plugins.authentication.impl.util.ProductLicenseDataProvider;
import com.atlassian.plugins.authentication.impl.web.usercontext.UserAuthenticatedEvent;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class PerNodeStatisticsCollectionService
extends AbstractStatisticsCollectionService {
    private static final Logger log = LoggerFactory.getLogger(PerNodeStatisticsCollectionService.class);
    private static final JobRunnerKey JOBRUNNER_KEY = JobRunnerKey.of((String)PerNodeStatisticsCollectionService.class.getCanonicalName());
    private static final JobId JOB_ID = JobId.of((String)"analytics-collection-local");
    private final AtomicLong jitDisabledAuthenticationCounter = new AtomicLong(0L);
    private final AtomicLong jitEnabledAuthenticationCounter = new AtomicLong(0L);
    private final NodeIdProvider nodeIdProvider;

    @Inject
    public PerNodeStatisticsCollectionService(@ComponentImport EventPublisher eventPublisher, @ComponentImport SchedulerService schedulerService, @ComponentImport ApplicationProperties applicationProperties, SsoConfigService ssoConfigService, ProductLicenseDataProvider productLicenseDataProvider, NodeIdProvider nodeIdProvider) {
        super(eventPublisher, schedulerService, applicationProperties, ssoConfigService, productLicenseDataProvider);
        this.nodeIdProvider = nodeIdProvider;
    }

    @Override
    @PostConstruct
    public void register() throws SchedulerServiceException {
        super.register();
        this.eventPublisher.register((Object)this);
    }

    @Override
    @PreDestroy
    public void unregister() {
        super.unregister();
        this.eventPublisher.unregister((Object)this);
    }

    @Override
    @NotNull
    protected RunMode getRunMode() {
        return RunMode.RUN_LOCALLY;
    }

    @Override
    protected JobId getJobId() {
        return JOB_ID;
    }

    @Override
    protected JobRunnerKey getJobRunnerKey() {
        return JOBRUNNER_KEY;
    }

    @EventListener
    public void onUserAuthenticatedEvent(UserAuthenticatedEvent event) {
        if (event.isJitEnabled()) {
            this.jitEnabledAuthenticationCounter.incrementAndGet();
        } else {
            this.jitDisabledAuthenticationCounter.incrementAndGet();
        }
    }

    @Override
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        log.debug("Collecting Local Authentications statistics");
        this.eventPublisher.publish((Object)new AuthenticationCountEvent(this.ssoConfigService.getSsoConfig(), this.applicationProperties.getPlatformId(), this.nodeIdProvider.getNodeId(), this.jitEnabledAuthenticationCounter.getAndSet(0L), this.jitDisabledAuthenticationCounter.getAndSet(0L)));
        return JobRunnerResponse.success();
    }
}

