/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.web.filter.authentication;

import com.atlassian.plugins.authentication.impl.config.SsoConfig;
import com.atlassian.plugins.authentication.impl.config.SsoConfigService;
import com.atlassian.plugins.authentication.impl.web.AuthenticationHandler;
import com.atlassian.plugins.authentication.impl.web.AuthenticationHandlerProvider;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthenticationFilter
implements Filter {
    protected final Logger log = LoggerFactory.getLogger(AuthenticationFilter.class);
    public static final String AUTH_FALLBACK_QUERY_PARAM = "auth_fallback";
    public static final String ATLASSIAN_RECOVERY_PASSWORD = "atlassian.recovery.password";
    protected final AuthenticationHandlerProvider authenticationHandlerProvider;
    protected final SsoConfigService ssoConfigService;

    public AuthenticationFilter(AuthenticationHandlerProvider authenticationHandlerProvider, SsoConfigService ssoConfigService) {
        this.authenticationHandlerProvider = authenticationHandlerProvider;
        this.ssoConfigService = ssoConfigService;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        try {
            Optional<AuthenticationHandler> authHandler = this.authenticationHandlerProvider.getAuthenticationHandler(this.ssoConfigService.getSsoType());
            if (!authHandler.isPresent() || !this.shouldAttemptAuthentication(req, resp, authHandler.get())) {
                chain.doFilter((ServletRequest)req, (ServletResponse)resp);
                return;
            }
            authHandler.get().processAuthenticationRequest(req, resp, this.extractRequestedUrl(req));
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            resp.sendError(Response.Status.BAD_REQUEST.getStatusCode(), e.getMessage());
        }
    }

    public void destroy() {
    }

    protected boolean shouldAttemptAuthentication(HttpServletRequest req, HttpServletResponse resp, AuthenticationHandler authHandler) throws IOException, ServletException, URISyntaxException {
        if (this.isSkipExternalAuthentication(req)) {
            this.log.trace("Not attempting external authentication, prevented by AuthenticationConfig");
            return false;
        }
        if (!authHandler.isCorrectlyConfigured()) {
            this.log.trace("Not attempting external authentication, AuthenticationHandler not configured");
            return false;
        }
        if (System.getProperty(ATLASSIAN_RECOVERY_PASSWORD) != null) {
            this.log.trace("Not attempting external authentication, Atlassian password recovery set");
            return false;
        }
        return true;
    }

    @Nullable
    protected abstract String extractRequestedUrl(HttpServletRequest var1);

    @VisibleForTesting
    boolean isSkipExternalAuthentication(HttpServletRequest request) {
        boolean hasQueryParam = request.getParameter(AUTH_FALLBACK_QUERY_PARAM) != null;
        SsoConfig ssoConfig = this.ssoConfigService.getSsoConfig();
        return ssoConfig != null && (hasQueryParam && ssoConfig.isAllowRedirectOverride() || !ssoConfig.isRedirectOnLogin());
    }
}

