/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.config.oidc;

import com.atlassian.plugins.authentication.impl.config.AbstractSsoConfigValidator;
import com.atlassian.plugins.authentication.impl.config.ErrorReason;
import com.atlassian.plugins.authentication.impl.config.SsoType;
import com.atlassian.plugins.authentication.impl.config.oidc.OidcConfig;
import com.atlassian.plugins.authentication.impl.util.HttpsValidator;
import com.atlassian.scheduler.cron.CronExpressionValidator;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMultimap;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;

@Named
public class OidcConfigValidator
extends AbstractSsoConfigValidator<OidcConfig> {
    private final CronExpressionValidator cronExpressionValidator;

    @Inject
    public OidcConfigValidator(HttpsValidator httpsValidator, CronExpressionValidator cronExpressionValidator) {
        super(httpsValidator);
        this.cronExpressionValidator = cronExpressionValidator;
    }

    @Override
    protected SsoType getSsoType() {
        return SsoType.OIDC;
    }

    @Override
    protected Class<OidcConfig> getSsoClass() {
        return OidcConfig.class;
    }

    @Override
    protected void validate(@Nonnull ImmutableMultimap.Builder<String, ErrorReason> errors, @Nonnull OidcConfig oidcConfig) {
        errors.putAll((Object)"issuer-url", this.validateRequiredField(oidcConfig.getIssuerUrl()));
        errors.putAll((Object)"client-id", this.validateRequiredField(oidcConfig.getClientId()));
        errors.putAll((Object)"client-secret", this.validateRequiredField(oidcConfig.getClientSecret()));
        errors.putAll((Object)"authorization-endpoint", this.validateRequiredField(oidcConfig.getAuthorizationEndpoint()));
        errors.putAll((Object)"token-endpoint", this.validateRequiredField(oidcConfig.getTokenEndpoint()));
        errors.putAll((Object)"userinfo-endpoint", this.validateRequiredField(oidcConfig.getUserInfoEndpoint()));
        errors.putAll((Object)"issuer-url", this.validateUrl(oidcConfig.getIssuerUrl()));
        errors.putAll((Object)"authorization-endpoint", this.validateUrl(oidcConfig.getAuthorizationEndpoint()));
        errors.putAll((Object)"token-endpoint", this.validateUrl(oidcConfig.getTokenEndpoint()));
        errors.putAll((Object)"userinfo-endpoint", this.validateUrl(oidcConfig.getUserInfoEndpoint()));
        errors.putAll((Object)"discovery-refresh-cron", this.validateCronExpression(oidcConfig.getDiscoveryRefreshCron()));
        errors.putAll((Object)"additional-scopes", this.validateAdditionalScopes(oidcConfig.getAdditionalScopes()));
        errors.putAll((Object)"username-claim", this.validateUsernameClaim(oidcConfig.getUsernameClaim()));
    }

    private Iterable<ErrorReason> validateCronExpression(String cronExpression) {
        if (!Strings.isNullOrEmpty((String)cronExpression) && !this.cronExpressionValidator.isValid(cronExpression)) {
            return ERROR_INCORRECT;
        }
        return NO_ERRORS;
    }

    private Iterable<ErrorReason> validateUsernameClaim(String value) {
        if (value != null && !StringUtils.isAsciiPrintable(value)) {
            return ERROR_INCORRECT;
        }
        return NO_ERRORS;
    }

    private Iterable<ErrorReason> validateAdditionalScopes(Iterable<String> values) {
        for (String value : values) {
            if (!StringUtils.isEmpty(value) && StringUtils.isAsciiPrintable(value) && !StringUtils.containsWhitespace(value)) continue;
            return ERROR_INCORRECT;
        }
        return NO_ERRORS;
    }
}

