/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.config;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.impl.config.SsoConfig;
import com.atlassian.plugins.authentication.impl.config.SsoType;
import com.atlassian.plugins.authentication.impl.config.oidc.OidcConfig;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfig;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class SsoConfigDao {
    private static final Logger logger = LoggerFactory.getLogger(SsoConfigDao.class);
    public static final String CFG_PREFIX = "com.atlassian.plugins.authentication.sso.config.";
    private static final Set<String> SUPPORT_ZIP_BLACKLISTED_FIELDS = ImmutableSet.of((Object)"client-secret");
    public static final String SUPPORT_ZIP_BLACKLISTED_PREFIX = "License.com.atlassian.plugins.authentication.sso.config.";
    private final PluginSettingsFactory pluginSettings;
    private final ApplicationProperties applicationProperties;

    @Inject
    public SsoConfigDao(@ComponentImport PluginSettingsFactory pluginSettings, @ComponentImport ApplicationProperties applicationProperties) {
        this.pluginSettings = pluginSettings;
        this.applicationProperties = applicationProperties;
    }

    @Nonnull
    public SsoType getSsoType() {
        String baseURL = this.applicationProperties.getBaseUrl(UrlMode.CANONICAL);
        if (Strings.isNullOrEmpty((String)baseURL)) {
            logger.info("Base URL is not set - not using SSO");
            return SsoType.NONE;
        }
        PluginSettings settings = this.settings();
        return Optional.ofNullable(this.getStringValue(settings, "sso-type")).flatMap(SsoType::fromName).orElse(SsoType.NONE);
    }

    @Nullable
    public SsoConfig getSsoConfig() {
        SsoType ssoType = this.getSsoType();
        if (ssoType == SsoType.NONE) {
            return null;
        }
        PluginSettings settings = this.settings();
        switch (ssoType) {
            case SAML: {
                return this.readGenericSsoConfig(settings, SamlConfig::builder).setIdpType(SamlConfig.IdpType.fromName(this.getStringValue(settings, "idp-type")).orElse(SamlConfig.IdpType.GENERIC)).setSsoUrl(this.getStringValue(settings, "sso-url")).setSsoIssuer(this.getStringValue(settings, "sso-issuer")).setCertificate(this.getStringValue(settings, "signing-cert")).setUsernameAttribute(this.getStringValue(settings, "username-attribute")).build();
            }
            case OIDC: {
                return this.readGenericSsoConfig(settings, OidcConfig::builder).setIssuerUrl(this.getStringValue(settings, "issuer-url")).setClientId(this.getStringValue(settings, "client-id")).setClientSecret(this.getStringValue(settings, "client-secret")).setAuthorizationEndpoint(this.getStringValue(settings, "authorization-endpoint")).setTokenEndpoint(this.getStringValue(settings, "token-endpoint")).setUserInfoEndpoint(this.getStringValue(settings, "userinfo-endpoint")).setDiscoveryEnabled(this.getBooleanValue(settings, "use-discovery", false)).setDiscoveryRefreshCron(this.getStringValue(settings, "discovery-refresh-cron")).setAdditionalScopes(this.getListValue(settings, "additional-scopes", String::valueOf)).setUsernameClaim(this.getStringValue(settings, "username-claim")).build();
            }
        }
        throw new IllegalStateException("Unknown type of SSO configured: " + (Object)((Object)ssoType));
    }

    private <T extends SsoConfig.Builder<T>> T readGenericSsoConfig(@Nonnull PluginSettings settings, @Nonnull Supplier<T> configSupplier) {
        return ((SsoConfig.Builder)((SsoConfig.Builder)((SsoConfig.Builder)((SsoConfig.Builder)configSupplier.get()).setRedirectOnLogin(this.getBooleanValue(settings, "redirect-on-login", false))).setAllowRedirectOverride(this.getBooleanValue(settings, "allow-redirect-override", false))).setIncludeCustomerLogins(this.getBooleanValue(settings, "include-customer-logins", false))).setEnableRememberMe(this.getBooleanValue(settings, "enable-remember-me", true));
    }

    public void removeSsoConfig() {
        PluginSettings settings = this.settings();
        Stream.of("sso-type", "redirect-on-login", "allow-redirect-override", "include-customer-logins", "enable-remember-me", "idp-type", "sso-url", "sso-issuer", "signing-cert", "username-attribute", "issuer-url", "client-id", "client-secret", "authorization-endpoint", "token-endpoint", "userinfo-endpoint", "use-discovery", "discovery-refresh-cron", "additional-scopes", "username-claim").forEach(config -> this.removeValue(settings, (String)config));
    }

    public void saveSsoConfig(@Nonnull SsoConfig ssoConfig) {
        PluginSettings settings = this.settings();
        switch (ssoConfig.getSsoType()) {
            case SAML: {
                this.removeSsoConfig();
                this.saveGenericSsoConfig(settings, ssoConfig);
                SamlConfig samlConfig = (SamlConfig)ssoConfig;
                this.setStringValue(settings, "idp-type", samlConfig.getIdpType().name());
                this.setStringValue(settings, "sso-url", samlConfig.getSsoUrl());
                this.setStringValue(settings, "sso-issuer", samlConfig.getSsoIssuer());
                this.setStringValue(settings, "signing-cert", samlConfig.getCertificate());
                this.setStringValue(settings, "username-attribute", Strings.emptyToNull((String)samlConfig.getUsernameAttribute()));
                break;
            }
            case OIDC: {
                this.removeSsoConfig();
                this.saveGenericSsoConfig(settings, ssoConfig);
                OidcConfig oidcConfig = (OidcConfig)ssoConfig;
                this.setStringValue(settings, "issuer-url", oidcConfig.getIssuerUrl());
                this.setStringValue(settings, "client-id", oidcConfig.getClientId());
                this.setStringValue(settings, "client-secret", oidcConfig.getClientSecret());
                this.setStringValue(settings, "authorization-endpoint", oidcConfig.getAuthorizationEndpoint());
                this.setStringValue(settings, "token-endpoint", oidcConfig.getTokenEndpoint());
                this.setStringValue(settings, "userinfo-endpoint", oidcConfig.getUserInfoEndpoint());
                this.setBooleanValue(settings, "use-discovery", oidcConfig.isDiscoveryEnabled());
                this.setStringValue(settings, "discovery-refresh-cron", oidcConfig.getDiscoveryRefreshCron());
                this.setListValue(settings, "additional-scopes", oidcConfig.getAdditionalScopes());
                this.setStringValue(settings, "username-claim", Strings.emptyToNull((String)oidcConfig.getUsernameClaim()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SSO type: " + (Object)((Object)ssoConfig.getSsoType()));
            }
        }
    }

    private void saveGenericSsoConfig(@Nonnull PluginSettings settings, @Nonnull SsoConfig ssoConfig) {
        this.setStringValue(settings, "sso-type", ssoConfig.getSsoType().name());
        this.setBooleanValue(settings, "allow-redirect-override", ssoConfig.isAllowRedirectOverride());
        this.setBooleanValue(settings, "include-customer-logins", ssoConfig.isIncludeCustomerLogins());
        this.setBooleanValue(settings, "redirect-on-login", ssoConfig.isRedirectOnLogin());
        this.setBooleanValue(settings, "enable-remember-me", ssoConfig.isEnableRememberMe());
    }

    @Nonnull
    private PluginSettings settings() {
        return this.pluginSettings.createGlobalSettings();
    }

    private void setBooleanValue(@Nonnull PluginSettings settings, @Nonnull String key, boolean value) {
        this.setStringValue(settings, key, Boolean.toString(value));
    }

    private void setStringValue(@Nonnull PluginSettings settings, @Nonnull String key, @Nullable String value) {
        settings.put(this.getFullKey(key), (Object)value);
    }

    private void setListValue(@Nonnull PluginSettings settings, @Nonnull String key, @Nullable List<String> value) {
        settings.put(this.getFullKey(key), (Object)(value == null ? null : new ArrayList<String>(value)));
    }

    private void removeValue(@Nonnull PluginSettings settings, @Nonnull String key) {
        settings.remove(this.getFullKey(key));
        settings.remove(CFG_PREFIX + key);
    }

    private String getFullKey(String key) {
        return (SUPPORT_ZIP_BLACKLISTED_FIELDS.contains(key) ? SUPPORT_ZIP_BLACKLISTED_PREFIX : CFG_PREFIX) + key;
    }

    @Nullable
    private String getStringValue(@Nonnull PluginSettings settings, @Nonnull String key) {
        Object value = this.getRawValue(settings, key);
        return value == null ? null : String.valueOf(value);
    }

    private boolean getBooleanValue(@Nonnull PluginSettings settings, @Nonnull String key, boolean defaultValue) {
        String storedValue = this.getStringValue(settings, key);
        return storedValue == null ? defaultValue : Boolean.parseBoolean(storedValue);
    }

    @Nonnull
    private <T> List<T> getListValue(@Nonnull PluginSettings settings, @Nonnull String key, @Nonnull Function<Object, T> elementMapper) {
        Object value = this.getRawValue(settings, key);
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof Iterable) {
            return StreamSupport.stream(((Iterable)value).spliterator(), false).map(elementMapper).collect(Collectors.toList());
        }
        logger.warn("Invalid type for key {}, expected {}, was {}", new Object[]{this.getFullKey(key), Iterable.class, value.getClass()});
        return Collections.emptyList();
    }

    private Object getRawValue(@Nonnull PluginSettings settings, @Nonnull String key) {
        return settings.get(this.getFullKey(key));
    }

    static interface Config {
        public static final String SSO_TYPE = "sso-type";
        public static final String REDIRECT_ON_LOGIN = "redirect-on-login";
        public static final String ALLOW_REDIRECT_OVERRIDE = "allow-redirect-override";
        public static final String INCLUDE_CUSTOMER_LOGINS = "include-customer-logins";
        public static final String ENABLE_REMEMBER_ME = "enable-remember-me";

        public static interface Oidc {
            public static final String ISSUER_URL = "issuer-url";
            public static final String CLIENT_ID = "client-id";
            public static final String CLIENT_SECRET = "client-secret";
            public static final String AUTHORIZATION_ENDPOINT = "authorization-endpoint";
            public static final String TOKEN_ENDPOINT = "token-endpoint";
            public static final String USER_INFO_ENDPOINT = "userinfo-endpoint";
            public static final String USE_DISCOVERY = "use-discovery";
            public static final String DISCOVERY_REFRESH_CRON = "discovery-refresh-cron";
            public static final String ADDITIONAL_SCOPES = "additional-scopes";
            public static final String USERNAME_CLAIM = "username-claim";
        }

        public static interface Saml {
            public static final String IDP_TYPE = "idp-type";
            public static final String SSO_URL = "sso-url";
            public static final String SSO_ISSUER = "sso-issuer";
            public static final String CERTIFICATE = "signing-cert";
            public static final String USER_ATTRIBUTE = "username-attribute";
        }
    }
}

