/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.config;

import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.event.SsoDisabledEvent;
import com.atlassian.plugins.authentication.event.SsoEnabledEvent;
import com.atlassian.plugins.authentication.impl.config.SsoConfigService;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BambooComponent
public class BambooSignupDisabler {
    private static final Logger logger = LoggerFactory.getLogger(BambooSignupDisabler.class);
    private static final String PREFIX = "com.atlassian.plugins.authentication.sso.config.";
    private static final String BAMBOO_SIGNUP_INITIALLY_DISABLED = "bamboo.signup.initially.disabled";
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private final EventPublisher eventPublisher;
    private final PluginSettingsFactory pluginSettings;
    private final SsoConfigService ssoConfigService;

    @Inject
    public BambooSignupDisabler(@ComponentImport AdministrationConfigurationAccessor administrationConfigurationAccessor, @ComponentImport EventPublisher eventPublisher, @ComponentImport PluginSettingsFactory pluginSettings, SsoConfigService ssoConfigService) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.eventPublisher = eventPublisher;
        this.pluginSettings = pluginSettings;
        this.ssoConfigService = ssoConfigService;
    }

    @PostConstruct
    public void setup() {
        this.eventPublisher.register((Object)this);
        this.disableBambooSignup();
    }

    @PreDestroy
    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onSsoEnabledEvent(SsoEnabledEvent event) {
        if (event.isLoginMandatory()) {
            this.disableBambooSignup();
        } else {
            this.restoreBambooSignupInitialState();
        }
    }

    @EventListener
    public void onSsoDisabledEvent(SsoDisabledEvent event) {
        this.restoreBambooSignupInitialState();
    }

    private Object setBooleanValue(String key, boolean value) {
        return this.settings().put(PREFIX + key, (Object)String.valueOf(value));
    }

    private Optional<Boolean> getBooleanValue(String key) {
        String value = (String)this.settings().get(PREFIX + key);
        return value == null ? Optional.empty() : Optional.of(Boolean.valueOf(value));
    }

    private PluginSettings settings() {
        return this.pluginSettings.createGlobalSettings();
    }

    private void disableBambooSignup() {
        if (this.ssoConfigService.getSsoConfig() != null) {
            boolean bambooSingnupInitiallyDisabled = this.getBooleanValue(BAMBOO_SIGNUP_INITIALLY_DISABLED).orElse(this.administrationConfigurationAccessor.getAdministrationConfiguration().isEnableSignup());
            this.setBooleanValue(BAMBOO_SIGNUP_INITIALLY_DISABLED, bambooSingnupInitiallyDisabled);
            this.administrationConfigurationAccessor.getAdministrationConfiguration().setEnableSignup(false);
            logger.info("Disabled bamboo signup. Initial state was: {}", (Object)(bambooSingnupInitiallyDisabled ? "disabled" : "enabled"));
        }
    }

    private void restoreBambooSignupInitialState() {
        this.getBooleanValue(BAMBOO_SIGNUP_INITIALLY_DISABLED).ifPresent(bambooSingnupInitiallyDisabled -> {
            this.administrationConfigurationAccessor.getAdministrationConfiguration().setEnableSignup(bambooSingnupInitiallyDisabled.booleanValue());
            logger.info("Restored bamboo signup state to: {}", (Object)(bambooSingnupInitiallyDisabled != false ? "disabled" : "enabled"));
        });
        this.settings().remove("com.atlassian.plugins.authentication.sso.config.bamboo.signup.initially.disabled");
    }
}

