/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.config;

import com.atlassian.bitbucket.audit.AuditEntry;
import com.atlassian.bitbucket.audit.AuditEntryBuilder;
import com.atlassian.bitbucket.audit.AuditEntryConverter;
import com.atlassian.bitbucket.audit.Priority;
import com.atlassian.bitbucket.event.annotation.Audited;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.event.saml.SamlDisabledEvent;
import com.atlassian.plugins.authentication.event.saml.SamlEnabledEvent;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

@BitbucketComponent
public class BitbucketAuditLogger {
    private final EventPublisher eventPublisher;

    @Inject
    public BitbucketAuditLogger(@ComponentImport EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @PostConstruct
    public void setup() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onSamlEnabledEvent(SamlEnabledEvent event) {
        this.eventPublisher.publish((Object)new BitbucketSamlEnabledEvent(event));
    }

    @EventListener
    public void onSamlDisabledEvent(SamlDisabledEvent event) {
        this.eventPublisher.publish((Object)new BitbucketSamlDisabledEvent(event));
    }

    public static interface BitbucketSamEvent {
    }

    public static class SamlEventConverter
    implements AuditEntryConverter<BitbucketSamEvent> {
        @Nonnull
        public AuditEntry convert(@Nonnull BitbucketSamEvent event, AuditEntryBuilder auditEntryBuilder) {
            return auditEntryBuilder.action(event.getClass()).timestamp(new Date()).build();
        }
    }

    @Audited(converter=SamlEventConverter.class, priority=Priority.HIGH)
    public static class BitbucketSamlEnabledEvent
    implements BitbucketSamEvent {
        private final SamlEnabledEvent event;

        public BitbucketSamlEnabledEvent(SamlEnabledEvent event) {
            this.event = event;
        }
    }

    @Audited(converter=SamlEventConverter.class, priority=Priority.HIGH)
    public static class BitbucketSamlDisabledEvent
    implements BitbucketSamEvent {
        private final SamlDisabledEvent event;

        public BitbucketSamlDisabledEvent(SamlDisabledEvent event) {
            this.event = event;
        }
    }
}

