/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.rest.saml.model;

import com.atlassian.plugins.authentication.impl.config.saml.SamlConfig;
import javax.xml.bind.annotation.XmlElement;

public class SamlConfigEntity {
    public static final String SSO_URL_FIELD = "sso-url";
    public static final String IDP_CERTIFICATE_FIELD = "certificate";
    public static final String USER_ATTRIBUTE_FIELD = "user-attribute";
    public static final String ALLOW_SAML_REDIRECT_OVERRIDE_FIELD = "allow-saml-redirect-override";
    public static final String INCLUDE_CUSTOMER_LOGINS = "include-customer-logins";
    public static final String REDIRECT_ON_LOGIN = "redirect-on-login";
    public static final String SSO_ISSUER_FIELD = "sso-issuer";
    public static final String ENABLE_REMEMBER_ME = "enable-remember-me";
    @XmlElement(name="sso-url", nillable=true)
    private String ssoUrl;
    @XmlElement(name="sso-issuer")
    private String ssoIssuer;
    @XmlElement(name="certificate", nillable=true)
    private String signingCert;
    @XmlElement(name="user-attribute", nillable=true)
    private String userAttribute;
    @XmlElement(name="allow-saml-redirect-override")
    private Boolean allowSamlRedirectOverride;
    @XmlElement(name="include-customer-logins")
    private Boolean includeCustomerLogins;
    @XmlElement(name="redirect-on-login")
    private Boolean redirectOnLogin;
    @XmlElement(name="enable-remember-me")
    private Boolean enableRememberMe;

    private SamlConfigEntity() {
    }

    public SamlConfigEntity(SamlConfig config) {
        this.ssoIssuer = config.getSsoIssuer();
        this.ssoUrl = config.getIdpSsoUrl();
        this.signingCert = config.getCertificate();
        this.userAttribute = config.getUsernameAttribute();
        this.allowSamlRedirectOverride = config.isAllowSamlRedirectOverride();
        this.includeCustomerLogins = config.isIncludeCustomerLogins();
        this.redirectOnLogin = config.isRedirectOnLogin();
        this.enableRememberMe = config.isEnableRememberMe();
    }

    public String getSsoUrl() {
        return this.ssoUrl;
    }

    public String getSigningCert() {
        return this.signingCert;
    }

    public String getUserAttribute() {
        return this.userAttribute;
    }

    public String getSsoIssuer() {
        return this.ssoIssuer;
    }

    public Boolean isAllowSamlRedirectOverride() {
        return this.allowSamlRedirectOverride;
    }

    public Boolean isIncludeCustomerLogins() {
        return this.includeCustomerLogins;
    }

    public Boolean isRedirectOnLogin() {
        return this.redirectOnLogin;
    }

    public Boolean isEnableRememberMe() {
        return this.enableRememberMe;
    }
}

