/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.rest.saml;

import com.atlassian.plugins.authentication.impl.config.saml.SamlConfig;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfigService;
import com.atlassian.plugins.authentication.impl.rest.saml.model.SamlConfigEntity;
import com.atlassian.plugins.authentication.impl.util.ApplicationStateValidator;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.sun.jersey.spi.container.ResourceFilters;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/saml")
@Named
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
public class SamlConfigResource {
    private final SamlConfigService configService;
    private final ApplicationStateValidator applicationStateValidator;

    @Inject
    public SamlConfigResource(SamlConfigService configService, ApplicationStateValidator applicationStateValidator) {
        this.configService = configService;
        this.applicationStateValidator = applicationStateValidator;
    }

    @GET
    public SamlConfigEntity getConfig() {
        return new SamlConfigEntity(this.configService.getSamlConfig());
    }

    @DELETE
    public void disableSaml() {
        this.configService.disable();
    }

    @PUT
    public SamlConfigEntity updateConfig(SamlConfigEntity newConfig) {
        this.applicationStateValidator.checkCanUpdateConfig();
        SamlConfig config = this.computeNewPossibleConfiguration(newConfig);
        this.configService.updateConfig(config);
        return new SamlConfigEntity(this.configService.getSamlConfig());
    }

    private SamlConfig computeNewPossibleConfiguration(SamlConfigEntity newConfig) {
        SamlConfig currentSamlConfig = this.configService.getSamlConfig();
        String signingCert = newConfig.getSigningCert() != null ? newConfig.getSigningCert() : currentSamlConfig.getCertificate();
        String ssoUrl = newConfig.getSsoUrl() != null ? newConfig.getSsoUrl() : currentSamlConfig.getIdpSsoUrl();
        String userAttribute = newConfig.getUserAttribute() != null ? newConfig.getUserAttribute() : currentSamlConfig.getUsernameAttribute();
        String ssoIssuer = newConfig.getSsoIssuer() != null ? newConfig.getSsoIssuer() : currentSamlConfig.getSsoIssuer();
        boolean allowSamlRedirectOverride = newConfig.isAllowSamlRedirectOverride() != null ? newConfig.isAllowSamlRedirectOverride().booleanValue() : currentSamlConfig.isAllowSamlRedirectOverride();
        boolean includeCustomerLogins = newConfig.isIncludeCustomerLogins() != null ? newConfig.isIncludeCustomerLogins().booleanValue() : currentSamlConfig.isIncludeCustomerLogins();
        boolean redirectOnLogin = newConfig.isRedirectOnLogin() != null ? newConfig.isRedirectOnLogin().booleanValue() : currentSamlConfig.isRedirectOnLogin();
        boolean enableRememberMe = newConfig.isEnableRememberMe() != null ? newConfig.isEnableRememberMe().booleanValue() : currentSamlConfig.isEnableRememberMe();
        return new SamlConfig(ssoUrl, ssoIssuer, userAttribute, signingCert, redirectOnLogin, includeCustomerLogins, allowSamlRedirectOverride, enableRememberMe);
    }
}

