/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.config.saml;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.authentication.event.saml.SamlDisabledEvent;
import com.atlassian.plugins.authentication.event.saml.SamlEnabledEvent;
import com.atlassian.plugins.authentication.impl.config.saml.ErrorReason;
import com.atlassian.plugins.authentication.impl.config.saml.InvalidConfigException;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfig;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfigValidator;
import com.atlassian.plugins.authentication.impl.config.saml.persistance.SamlConfigDAO;
import com.google.common.collect.Multimap;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class SamlConfigService {
    private final SamlConfigDAO samlConfigDAO;
    private final SamlConfigValidator samlConfigValidator;
    private final EventPublisher eventPublisher;

    @Inject
    public SamlConfigService(SamlConfigDAO samlConfigDAO, SamlConfigValidator samlConfigValidator, @ComponentImport EventPublisher eventPublisher) {
        this.samlConfigDAO = samlConfigDAO;
        this.samlConfigValidator = samlConfigValidator;
        this.eventPublisher = eventPublisher;
    }

    public void disable() {
        this.samlConfigDAO.remove();
        this.eventPublisher.publish((Object)new SamlDisabledEvent());
    }

    public SamlConfig getSamlConfig() {
        return this.samlConfigDAO.load();
    }

    public void updateConfig(SamlConfig newConfig) {
        Objects.requireNonNull(newConfig, "Saml configuration cannot be null");
        Multimap<String, ErrorReason> errorsOnFields = this.samlConfigValidator.validate(newConfig);
        if (!errorsOnFields.isEmpty()) {
            throw new InvalidConfigException(errorsOnFields);
        }
        SamlConfig previousSamlConfig = this.samlConfigDAO.load();
        this.samlConfigDAO.save(newConfig);
        this.publishEventIfConfigChanged(newConfig, previousSamlConfig);
    }

    private void publishEventIfConfigChanged(SamlConfig newConfig, SamlConfig previousSamlConfig) {
        if (previousSamlConfig.isConfigured() != newConfig.isConfigured() || previousSamlConfig.isRedirectOnLogin() != newConfig.isRedirectOnLogin()) {
            this.eventPublisher.publish((Object)new SamlEnabledEvent(newConfig.isRedirectOnLogin()));
        }
    }
}

