/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.web.saml;

import com.atlassian.plugins.authentication.impl.web.saml.provider.SamlRequest;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;

public class SessionData
implements Serializable {
    private final SamlRequest samlRequest;
    private final URI targetUrl;

    SessionData(SamlRequest samlRequest, URI targetUrl) {
        this.samlRequest = (SamlRequest)Preconditions.checkNotNull((Object)samlRequest);
        this.targetUrl = targetUrl;
    }

    public SamlRequest getSamlRequest() {
        return this.samlRequest;
    }

    public Optional<URI> getTargetUrl() {
        return Optional.ofNullable(this.targetUrl);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("authnRequestId", (Object)this.samlRequest).add("targetUrl", (Object)this.targetUrl).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionData that = (SessionData)o;
        return Objects.equals(this.samlRequest, that.samlRequest) && Objects.equals(this.targetUrl, that.targetUrl);
    }

    public int hashCode() {
        return Objects.hash(this.samlRequest, this.targetUrl);
    }
}

