/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.web;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import java.util.Arrays;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Named
public class CookieService {
    private final ApplicationProperties applicationProperties;

    @Inject
    public CookieService(@ComponentImport ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public Optional<Cookie> getCookieFromRequest(String cookieName, HttpServletRequest request) {
        Cookie[] cookies = Optional.ofNullable(request.getCookies()).orElse(new Cookie[0]);
        return Arrays.stream(cookies).filter(cookie -> cookie.getName().equals(cookieName)).findAny();
    }

    public void removeCookie(String cookieName, HttpServletResponse response) {
        Cookie cookieToRemove = new Cookie(cookieName, null);
        cookieToRemove.setMaxAge(0);
        cookieToRemove.setPath(this.applicationProperties.getBaseUrl(UrlMode.RELATIVE));
        response.addCookie(cookieToRemove);
    }
}

