/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.impl.config;

import com.atlassian.plugins.authentication.impl.config.saml.SamlConfig;
import com.atlassian.plugins.authentication.impl.config.saml.SamlConfigService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Named
public class AuthenticationConfig {
    public static final String AUTH_FALLBACK_QUERY_PARAM = "auth_fallback";
    private final SamlConfigService samlConfigService;

    @Inject
    public AuthenticationConfig(SamlConfigService samlConfigService) {
        this.samlConfigService = samlConfigService;
    }

    public boolean isSkipExternalAuthentication(HttpServletRequest request, HttpServletResponse response) {
        boolean hasQueryParam = request.getParameter(AUTH_FALLBACK_QUERY_PARAM) != null;
        SamlConfig samlConfig = this.samlConfigService.getSamlConfig();
        return hasQueryParam && samlConfig.isAllowSamlRedirectOverride() || !samlConfig.isRedirectOnLogin();
    }

    public boolean isIncludeCustomerLogins() {
        SamlConfig samlConfig = this.samlConfigService.getSamlConfig();
        return samlConfig.isIncludeCustomerLogins();
    }
}

