package com.atlassian.plugins.whitelist.events;

import com.atlassian.plugins.whitelist.WhitelistRule;
import org.checkerframework.checker.nullness.qual.NonNull;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Objects;

import static java.util.Objects.requireNonNull;

/**
 * After an existing whitelist rule has been changed.
 * @since 1.0
 */
public class WhitelistRuleChangedEvent extends WhitelistRuleEvent
{
    @Nullable
    private final WhitelistRule oldRule;

    public WhitelistRuleChangedEvent(@Nonnull final WhitelistRule whitelistRule)
    {
        this(null, whitelistRule);
    }

    public WhitelistRuleChangedEvent(@Nullable final WhitelistRule oldRule, @Nonnull final WhitelistRule newRule)
    {
        super(requireNonNull(newRule));
        this.oldRule = oldRule;
    }

    @Nullable
    public WhitelistRule getOldRule()
    {
        return oldRule;
    }

    @NonNull
    public WhitelistRule getNewRule()
    {
        return whitelistRule;
    }

    @Override
    public boolean equals(Object o)
    {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        WhitelistRuleChangedEvent that = (WhitelistRuleChangedEvent) o;
        return Objects.equals(getOldRule(), that.getOldRule()) &&
                Objects.equals(getNewRule(), that.getNewRule());
    }

    @Override
    public int hashCode()
    {
        return Objects.hash(getOldRule(), getNewRule());
    }

    @Override
    public String toString() {
        return "WhitelistRuleChangedEvent{" +
                "oldRule=" + getOldRule() +
                ", newRule=" + getNewRule() +
                '}';
    }
}
