package com.atlassian.plugins.whitelist;

import com.atlassian.annotations.PublicApi;

import java.net.URI;

/**
 * Check if access to a given uri is allowed or not.
 * @since 1.0
 */
@PublicApi
public interface Whitelist
{
    /**
     * Checks if requests to the provided URI are allowed according to the current whitelist configuration
     * @param uri the uri a http request is made to
     * @return true if requests are allowed, false otherwise
     */
    boolean isAllowed(URI uri);
}
