package com.atlassian.plugins.whitelist;

import javax.annotation.concurrent.Immutable;

import com.atlassian.annotations.PublicApi;

import org.apache.commons.lang.StringUtils;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * @since 1.0
 */
@Immutable
@PublicApi
public final class LegacyWhitelistRule implements WhitelistRule
{
    private final String expression;
    private final WhitelistType type;

    public LegacyWhitelistRule(final String acceptRule)
    {
        checkNotNull(acceptRule, "acceptRule");
        if (acceptRule.startsWith("="))
        {
            this.expression = StringUtils.removeStart(acceptRule, "=");
            this.type = WhitelistType.EXACT_URL;
        }
        else if (acceptRule.startsWith("/"))
        {
            this.expression = StringUtils.removeStart(acceptRule, "/");
            this.type = WhitelistType.REGULAR_EXPRESSION;
        }
        else
        {
            this.expression = acceptRule;
            this.type = WhitelistType.WILDCARD_EXPRESSION;
        }
    }

    @Override
    public Integer getId()
    {
        return null;
    }

    @Override
    public String getExpression()
    {
        return expression;
    }

    @Override
    public WhitelistType getType()
    {
        return type;
    }

    @Override
    public boolean isAllowInbound()
    {
        return false;
    }

    @Override
    public String toString()
    {
        return "LegacyWhitelistRule{expression='" + expression + '\'' + ", type=" + type + '}';
    }
}
