/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.matcher;

import com.atlassian.plugins.whitelist.matcher.MatcherUtils;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import java.net.URI;
import java.net.URISyntaxException;

public class SelfUrlMatcher
implements Predicate<URI> {
    private final ApplicationProperties applicationProperties;

    public SelfUrlMatcher(ApplicationProperties applicationProperties) {
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
    }

    public boolean apply(URI uri) {
        try {
            URI normalizedUri = MatcherUtils.normalizeUri(uri);
            String baseUrl = Strings.nullToEmpty((String)this.applicationProperties.getBaseUrl(UrlMode.CANONICAL));
            return normalizedUri.toString().startsWith(baseUrl);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

