/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist.applinks;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.plugins.whitelist.matcher.MatcherUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.net.URI;
import java.net.URISyntaxException;

public class ApplicationLinkMatcher
implements Predicate<URI> {
    private String applinkRpcUrl;

    public ApplicationLinkMatcher(ApplicationLink applicationLink) {
        this.applinkRpcUrl = ((ApplicationLink)Preconditions.checkNotNull((Object)applicationLink, (Object)"applicationLink")).getRpcUrl().toString();
    }

    public boolean apply(URI uri) {
        try {
            return MatcherUtils.normalizeUri(uri).toString().startsWith(this.applinkRpcUrl);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

