/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.whitelist;

import com.atlassian.annotations.PublicApi;
import com.atlassian.plugins.whitelist.ImmutableWhitelistRuleBuilder;
import com.atlassian.plugins.whitelist.WhitelistRule;
import com.atlassian.plugins.whitelist.WhitelistType;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;

@Immutable
@PublicApi
public final class ImmutableWhitelistRule
implements WhitelistRule {
    private final Integer id;
    private final String expression;
    private final WhitelistType type;
    private final boolean allowInbound;

    public ImmutableWhitelistRule(ImmutableWhitelistRuleBuilder builder) {
        Preconditions.checkNotNull((Object)builder, (Object)"builder");
        this.id = builder.id;
        this.expression = (String)Preconditions.checkNotNull((Object)builder.expression, (Object)"expression");
        this.type = (WhitelistType)((Object)Preconditions.checkNotNull((Object)((Object)builder.type), (Object)"type"));
        this.allowInbound = builder.allowInbound;
    }

    public static ImmutableWhitelistRuleBuilder builder() {
        return new ImmutableWhitelistRuleBuilder();
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public WhitelistType getType() {
        return this.type;
    }

    @Override
    public boolean isAllowInbound() {
        return this.allowInbound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableWhitelistRule that = (ImmutableWhitelistRule)o;
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.expression, (Object)that.expression) && Objects.equal((Object)((Object)this.type), (Object)((Object)that.type)) && Objects.equal((Object)this.allowInbound, (Object)that.allowInbound);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.expression, this.type, this.allowInbound});
    }

    public String toString() {
        return "ImmutableWhitelistRule{id=" + this.id + ", expression='" + this.expression + '\'' + ", type=" + (Object)((Object)this.type) + ", allowInbound=" + this.allowInbound + '}';
    }
}

