package com.atlassian.plugins.whitelist.permission;

/**
 * This purely exists to support the permission check implementation swap in JIRA when running in the context of the
 * system (e.g. an upgrade task).
 * @since 1.0
 */
public interface PermissionChecker
{
    /**
     * @return <code>true</code> if the user is allowed to manage the whitelist, <code>false</code> otherwise
     */
    boolean canCurrentUserManageWhitelist();

    /**
     * @throws com.atlassian.plugins.whitelist.NotAuthorizedException if the current user has not the required
     * permissions
     */
    void checkCurrentUserCanManageWhitelist();
}
