package com.atlassian.plugins.whitelist.ao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugins.whitelist.WhitelistRule;
import net.java.ao.DBParam;

import java.util.Arrays;
import java.util.List;

import static com.atlassian.plugins.whitelist.ao.AoWhitelistRule.ALLOW_INBOUND_COLUMN;
import static com.atlassian.plugins.whitelist.ao.AoWhitelistRule.EXPRESSION_COLUMN;
import static com.atlassian.plugins.whitelist.ao.AoWhitelistRule.TYPE_COLUMN;
import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Manage access to the active objects storage. The usage of a transaction is left upon the caller.
 * @since 1.0
 */
public class AoWhitelistRuleDao
{
    private final ActiveObjects activeObjects;

    public AoWhitelistRuleDao(final ActiveObjects activeObjects)
    {
        this.activeObjects = checkNotNull(activeObjects);
    }

    public List<AoWhitelistRule> getAll()
    {
        return Arrays.asList(activeObjects.find(AoWhitelistRule.class));
    }

    public AoWhitelistRule get(final int id)
    {
        return activeObjects.get(AoWhitelistRule.class, id);
    }

    public AoWhitelistRule add(final WhitelistRule data)
    {
        return activeObjects.create(
                AoWhitelistRule.class,
                new DBParam(EXPRESSION_COLUMN, data.getExpression()),
                new DBParam(TYPE_COLUMN, data.getType()),
                new DBParam(ALLOW_INBOUND_COLUMN, data.isAllowInbound())
        );
    }

    public void remove(final int id)
    {
        final AoWhitelistRule model = activeObjects.get(AoWhitelistRule.class, id);
        if (model != null)
        {
            activeObjects.delete(model);
        }
    }
}
