/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl.diagnostics;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.applinks.api.event.ApplicationLinkAddedEvent;
import com.atlassian.applinks.api.event.ApplicationLinkAuthConfigChangedEvent;
import com.atlassian.applinks.api.event.ApplicationLinkDetailsChangedEvent;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.event.remote.diagnostics.ApplicationLinkStatus;
import com.atlassian.event.remote.diagnostics.ProviderStatus;
import com.atlassian.event.remote.diagnostics.RemoteEventConnectionStatus;
import com.atlassian.event.remote.impl.diagnostics.RemoteConnectionTester;
import com.atlassian.event.remote.impl.diagnostics.RemoteStatus;
import com.atlassian.event.remote.internal.auth.RequestAuthorizor;
import com.atlassian.event.remote.internal.http.HttpUtil;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.capabilities.api.LinkedAppWithCapabilities;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={RemoteEventConnectionStatus.class})
public class DefaultRemoteEventConnectionStatus
implements RemoteEventConnectionStatus {
    private static final Logger log = LoggerFactory.getLogger(DefaultRemoteEventConnectionStatus.class);
    private static final Duration CONNECTION_STATUS_MAX_AGE = Duration.standardSeconds((long)Integer.getInteger("remote.event.connectionstatus.maxage.seconds", 60).intValue());
    public static final String REMOTE_EVENT_DIAGNOSTICS_V1_CAPABILITY = "atlassian-remote-event-diagnostics-v1";
    private final ApplicationLinkService applicationLinks;
    private final HttpUtil httpUtil;
    private final RemoteConnectionTester remoteConnectionTester;
    private final RequestAuthorizor requestAuthorizor;
    private final EventPublisher eventPublisher;
    private final CacheManager cacheManager;
    private Cache<ApplicationId, Optional<ApplicationLinkStatus>> applicationConnectionStatus;

    @Autowired
    public DefaultRemoteEventConnectionStatus(@ComponentImport ApplicationLinkService applicationLinks, @ComponentImport EventPublisher eventPublisher, HttpUtil httpUtil, RemoteConnectionTester remoteConnectionTester, RequestAuthorizor requestAuthorizor, @ComponentImport CacheManager cacheManager) {
        this.applicationLinks = applicationLinks;
        this.eventPublisher = eventPublisher;
        this.httpUtil = httpUtil;
        this.remoteConnectionTester = remoteConnectionTester;
        this.requestAuthorizor = requestAuthorizor;
        this.cacheManager = cacheManager;
        this.createCache();
    }

    private void createCache() {
        this.applicationConnectionStatus = this.cacheManager.getCache(DefaultRemoteEventConnectionStatus.class.getName() + ".connectionStatusCache", (CacheLoader)new CacheLoader<ApplicationId, Optional<ApplicationLinkStatus>>(){

            public Optional<ApplicationLinkStatus> load(@Nonnull ApplicationId applicationId) {
                return Optional.ofNullable(DefaultRemoteEventConnectionStatus.this.getApplicationLinkStatus(applicationId));
            }
        }, new CacheSettingsBuilder().expireAfterWrite(CONNECTION_STATUS_MAX_AGE.getStandardSeconds(), TimeUnit.SECONDS).local().flushable().build());
    }

    @PostConstruct
    public void registerListener() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void unregisterListener() {
        this.eventPublisher.unregister((Object)this);
    }

    public Map<ApplicationId, ApplicationLinkStatus> getConnectionStatus() {
        ImmutableMap.Builder appLinkStatusMap = ImmutableMap.builder();
        for (ApplicationLink appLink : this.applicationLinks.getApplicationLinks()) {
            ApplicationLinkStatus connectionStatus = this.getConnectionStatus(appLink.getId());
            if (connectionStatus == null) continue;
            appLinkStatusMap.put((Object)appLink.getId(), (Object)connectionStatus);
        }
        return appLinkStatusMap.build();
    }

    public ApplicationLinkStatus getConnectionStatus(ApplicationId applicationId) {
        return ((Optional)this.applicationConnectionStatus.get((Object)applicationId)).orElse(null);
    }

    public void reset() {
        this.applicationConnectionStatus.removeAll();
    }

    @EventListener
    public void onAppLinkAdded(ApplicationLinkAddedEvent applicationLinkAddedEvent) {
        this.reset();
    }

    @EventListener
    public void onAppLinkChanged(ApplicationLinkDetailsChangedEvent applicationLinkDetailsChangedEvent) {
        this.reset();
    }

    @EventListener
    public void onAppLinkAuthConfigChanged(ApplicationLinkAuthConfigChangedEvent applicationLinkAuthConfigChangedEvent) {
        this.reset();
    }

    private ApplicationLinkStatus getApplicationLinkStatus(ApplicationId applicationId) {
        ApplicationLinkStatus applicationLinkStatus;
        LinkedAppWithCapabilities app = this.httpUtil.getAppWithCapabilities(applicationId.get(), REMOTE_EVENT_DIAGNOSTICS_V1_CAPABILITY);
        if (app != null && (applicationLinkStatus = this.getApplicationLinkStatus(applicationId, app)) != null) {
            return applicationLinkStatus;
        }
        return null;
    }

    private ApplicationLinkStatus getApplicationLinkStatus(ApplicationId applicationId, LinkedAppWithCapabilities app) {
        try {
            ApplicationLink applicationLink = this.applicationLinks.getApplicationLink(applicationId);
            ApplicationLinkStatus.Builder builder = new ApplicationLinkStatus.Builder(applicationLink);
            RemoteEventConnectionStatus.ConnectionStatus remoteConnectionStatus = this.remoteConnectionTester.canRemoteAcceptEvents(applicationLink, app);
            builder.setOutboundConnectionStatus(remoteConnectionStatus);
            Optional<RemoteStatus> remoteStatus = this.remoteConnectionTester.getRemoteStatus(applicationLink, app);
            builder.setInboundConnectionStatus(remoteStatus.map(RemoteStatus::getConnectionStatus).orElse(RemoteEventConnectionStatus.ConnectionStatus.UNKNOWN));
            for (Map.Entry<Class<? extends AuthenticationProvider>, Boolean> e : this.requestAuthorizor.getAuthenticationProviderStatuses(applicationLink).entrySet()) {
                ProviderStatus.Builder providerStatusBuilder = new ProviderStatus.Builder();
                providerStatusBuilder.setLocalConfigured(e.getValue());
                remoteStatus.ifPresent(status -> providerStatusBuilder.setRemoteConfigured(status.isConfigured((Class)e.getKey())));
                builder.addConnectionStatus(e.getKey(), providerStatusBuilder);
            }
            return builder.build();
        }
        catch (TypeNotInstalledException e) {
            log.info("Error accessing application link for " + applicationId, (Throwable)e);
            return null;
        }
    }
}

