/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl.diagnostics;

import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.event.remote.diagnostics.RemoteEventConnectionStatus;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;

public class RemoteStatus {
    public static final RemoteStatus EMPTY_STATUS = new Builder().setConnectionStatus(RemoteEventConnectionStatus.ConnectionStatus.UNKNOWN).build();
    private final Map<String, Boolean> configuredAuthenticationProviders;
    private final boolean working;
    private final RemoteEventConnectionStatus.ConnectionStatus connectionStatus;

    private RemoteStatus() {
        this.working = false;
        this.connectionStatus = RemoteEventConnectionStatus.ConnectionStatus.LEGACY;
        this.configuredAuthenticationProviders = ImmutableMap.of();
    }

    public RemoteStatus(Builder builder) {
        this.configuredAuthenticationProviders = builder.configuredAuthenticationProviders.build();
        this.working = builder.connectionStatus == RemoteEventConnectionStatus.ConnectionStatus.WORKING;
        this.connectionStatus = builder.connectionStatus;
    }

    public Map<String, Boolean> getConfiguredAuthenticationProviders() {
        return this.configuredAuthenticationProviders;
    }

    public boolean isWorking() {
        return this.working;
    }

    public RemoteEventConnectionStatus.ConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this).toString();
    }

    public Boolean isConfigured(Class<? extends AuthenticationProvider> authenticationProvider) {
        return this.configuredAuthenticationProviders.get(RemoteStatus.getAuthenticationProviderName(authenticationProvider));
    }

    private static String getAuthenticationProviderName(Class<? extends AuthenticationProvider> authenticationProvider) {
        return authenticationProvider.getName();
    }

    public static class Builder {
        private final ImmutableMap.Builder<String, Boolean> configuredAuthenticationProviders = new ImmutableMap.Builder();
        private RemoteEventConnectionStatus.ConnectionStatus connectionStatus = RemoteEventConnectionStatus.ConnectionStatus.UNKNOWN;

        public Builder addConfiguredAuthenticationProviders(Map<Class<? extends AuthenticationProvider>, Boolean> m) {
            for (Map.Entry<Class<? extends AuthenticationProvider>, Boolean> e : m.entrySet()) {
                this.configuredAuthenticationProviders.put((Object)RemoteStatus.getAuthenticationProviderName(e.getKey()), (Object)e.getValue());
            }
            return this;
        }

        public RemoteStatus build() {
            return new RemoteStatus(this);
        }

        public Builder setConnectionStatus(RemoteEventConnectionStatus.ConnectionStatus connectionStatus) {
            this.connectionStatus = connectionStatus != null ? connectionStatus : RemoteEventConnectionStatus.ConnectionStatus.UNKNOWN;
            return this;
        }
    }
}

