/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl.auth;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.auth.Anonymous;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.applinks.api.auth.types.TwoLeggedOAuthAuthenticationProvider;
import com.atlassian.event.remote.internal.auth.RequestAuthorizor;
import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.serviceprovider.ServiceProviderConsumerStore;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.OAuthRequestVerifierFactory;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={RequestAuthorizor.class})
public class DefaultRequestAuthorizor
implements RequestAuthorizor {
    private static final Logger log = LoggerFactory.getLogger(DefaultRequestAuthorizor.class);
    public static final String ATLASSIAN_DEV_MODE = "atlassian.dev.mode";
    public static final String OAUTH_INCOMING_CONSUMER_KEY = "oauth.incoming.consumerkey";
    private final OAuthRequestVerifierFactory oAuthRequestVerifierFactory;
    private final ServiceProviderConsumerStore consumerStore;
    private final UserManager userManager;
    private volatile RequestAuthorizor.Mode mode = RequestAuthorizor.Mode.NORMAL;

    @Autowired
    public DefaultRequestAuthorizor(@ComponentImport OAuthRequestVerifierFactory oAuthRequestVerifierFactory, @ComponentImport ServiceProviderConsumerStore consumerStore, @ComponentImport UserManager userManager) {
        this.oAuthRequestVerifierFactory = oAuthRequestVerifierFactory;
        this.consumerStore = consumerStore;
        this.userManager = userManager;
    }

    @Override
    public boolean isAuthorized() {
        switch (this.mode) {
            case ALLOW_ALL: {
                return true;
            }
            case BLOCK_ALL: {
                return false;
            }
        }
        return this.oAuthRequestVerifierFactory.getInstance(null).isVerified() && this.userManager.getRemoteUserKey() == null;
    }

    @Override
    public void setMode(RequestAuthorizor.Mode mode) {
        if (!this.isDevMode()) {
            throw new UnsupportedOperationException("Setting the authorization mode is only available in dev-mode.\nUse the system property 'atlassian.dev.mode=true' to set this.");
        }
        this.mode = mode;
    }

    @Override
    public Iterable<Class<? extends AuthenticationProvider>> getAllowedAuthenticationProviders() {
        return Lists.newArrayList((Object[])new Class[]{TwoLeggedOAuthAuthenticationProvider.class});
    }

    @Override
    public Map<Class<? extends AuthenticationProvider>, Boolean> getAuthenticationProviderStatuses(ApplicationLink applicationLink) {
        return ImmutableMap.of(TwoLeggedOAuthAuthenticationProvider.class, (Object)this.is2LOConfigured(applicationLink));
    }

    @Override
    public ApplicationLinkRequestFactory getAuthorizedRequestFactory(ApplicationLink applicationLink) {
        ApplicationLinkRequestFactory factory = null;
        if (this.is2LOConfigured(applicationLink)) {
            factory = applicationLink.createNonImpersonatingAuthenticatedRequestFactory();
        } else {
            log.debug("Missing 2LO for {}, trying anonymous", (Object)applicationLink);
        }
        return factory != null ? factory : applicationLink.createAuthenticatedRequestFactory(Anonymous.class);
    }

    private boolean is2LOConfigured(ApplicationLink applicationLink) {
        Consumer consumer;
        Object consumerKey = applicationLink.getProperty(OAUTH_INCOMING_CONSUMER_KEY);
        if (consumerKey != null && (consumer = this.consumerStore.get(consumerKey.toString())) != null) {
            return consumer.getTwoLOAllowed();
        }
        return false;
    }

    private boolean isDevMode() {
        return Boolean.getBoolean(ATLASSIAN_DEV_MODE);
    }
}

