/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.diagnostics;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.event.remote.diagnostics.ProviderStatus;
import com.atlassian.event.remote.diagnostics.RemoteEventConnectionStatus;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class ApplicationLinkStatus {
    private final ApplicationLink applicationLink;
    private final Map<Class<? extends AuthenticationProvider>, ProviderStatus> acceptedProviders;
    private final RemoteEventConnectionStatus.ConnectionStatus inboundConnectionStatus;
    private final RemoteEventConnectionStatus.ConnectionStatus outboundConnectionStatus;

    public ApplicationLinkStatus(Builder builder) {
        this.applicationLink = builder.applicationLink;
        this.acceptedProviders = Maps.transformValues((Map)builder.acceptedProvidersBuilder.build(), (Function)new Function<ProviderStatus.Builder, ProviderStatus>(){

            public ProviderStatus apply(@Nullable ProviderStatus.Builder input) {
                return input.build();
            }
        });
        this.inboundConnectionStatus = builder.inboundConnectionStatus;
        this.outboundConnectionStatus = builder.outboundConnectionStatus;
    }

    public Map<Class<? extends AuthenticationProvider>, ProviderStatus> getAcceptedProviders() {
        return this.acceptedProviders;
    }

    public ApplicationLink getApplicationLink() {
        return this.applicationLink;
    }

    public RemoteEventConnectionStatus.ConnectionStatus getInboundConnectionStatus() {
        return this.inboundConnectionStatus;
    }

    public RemoteEventConnectionStatus.ConnectionStatus getOutboundConnectionStatus() {
        return this.outboundConnectionStatus;
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this).toString();
    }

    public static class Builder {
        private final ApplicationLink applicationLink;
        private final ImmutableMap.Builder<Class<? extends AuthenticationProvider>, ProviderStatus.Builder> acceptedProvidersBuilder = new ImmutableMap.Builder();
        private RemoteEventConnectionStatus.ConnectionStatus inboundConnectionStatus = RemoteEventConnectionStatus.ConnectionStatus.UNKNOWN;
        private RemoteEventConnectionStatus.ConnectionStatus outboundConnectionStatus = RemoteEventConnectionStatus.ConnectionStatus.UNKNOWN;

        public Builder(ApplicationLink applicationLink) {
            this.applicationLink = applicationLink;
        }

        public Builder addConnectionStatus(Class<? extends AuthenticationProvider> authenticationProvider, ProviderStatus.Builder providerStatus) {
            this.acceptedProvidersBuilder.put(authenticationProvider, (Object)providerStatus);
            return this;
        }

        public ApplicationLinkStatus build() {
            return new ApplicationLinkStatus(this);
        }

        public Builder setInboundConnectionStatus(RemoteEventConnectionStatus.ConnectionStatus connectionStatus) {
            this.inboundConnectionStatus = connectionStatus;
            return this;
        }

        public Builder setOutboundConnectionStatus(RemoteEventConnectionStatus.ConnectionStatus connectionStatus) {
            this.outboundConnectionStatus = connectionStatus;
            return this;
        }
    }
}

