/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.util;

import java.util.Comparator;
import org.apache.commons.lang.StringUtils;

public class VersionStringComparator
implements Comparator {
    public static final String DELIMITER_PATTERN = "[\\.,-]";
    public static final String COMPONENT_PATTERN = "[\\d\\w]+";
    public static final String VALID_VERSION_PATTERN = "[\\d\\w]+([\\.,-][\\d\\w]+)*";

    public static boolean isValidVersionString(String version) {
        return version != null && version.matches(VALID_VERSION_PATTERN);
    }

    public int compare(Object o1, Object o2) {
        if (!(o1 instanceof String)) {
            return 0;
        }
        if (!(o2 instanceof String)) {
            return 0;
        }
        return this.compare((String)o1, (String)o2);
    }

    public int compare(String version1, String version2) {
        String thisVersion = "0";
        if (StringUtils.isNotEmpty((String)version1)) {
            thisVersion = version1.replaceAll(" ", "");
        }
        String compareVersion = "0";
        if (StringUtils.isNotEmpty((String)version2)) {
            compareVersion = version2.replaceAll(" ", "");
        }
        if (!thisVersion.matches(VALID_VERSION_PATTERN) || !compareVersion.matches(VALID_VERSION_PATTERN)) {
            throw new IllegalArgumentException("Version number '" + thisVersion + "' cannot be compared to '" + compareVersion + "'");
        }
        String[] v1 = thisVersion.split(DELIMITER_PATTERN);
        String[] v2 = compareVersion.split(DELIMITER_PATTERN);
        VersionStringComponentComparator componentComparator = new VersionStringComponentComparator();
        for (int i = 0; i < (v1.length > v2.length ? v1.length : v2.length); ++i) {
            String component2;
            String component1 = i >= v1.length ? "0" : v1[i];
            String string = component2 = i >= v2.length ? "0" : v2[i];
            if (componentComparator.compare(component1, component2) == 0) continue;
            return componentComparator.compare(component1, component2);
        }
        return 0;
    }

    private class VersionStringComponentComparator
    implements Comparator {
        public static final int FIRST_GREATER = 1;
        public static final int SECOND_GREATER = -1;

        private VersionStringComponentComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof String)) {
                return 0;
            }
            if (!(o2 instanceof String)) {
                return 0;
            }
            return this.compare((String)o1, (String)o2);
        }

        public int compare(String component1, String component2) {
            if (component1.equalsIgnoreCase(component2)) {
                return 0;
            }
            if (this.isInteger(component1) && this.isInteger(component2)) {
                if (Integer.parseInt(component1) > Integer.parseInt(component2)) {
                    return 1;
                }
                if (Integer.parseInt(component2) > Integer.parseInt(component1)) {
                    return -1;
                }
                return 0;
            }
            if ("0".equals(component1)) {
                return 1;
            }
            if ("0".equals(component2)) {
                return -1;
            }
            if (this.isInteger(component1) && component2.startsWith(component1)) {
                return 1;
            }
            if (this.isInteger(component2) && component1.startsWith(component2)) {
                return -1;
            }
            return component1.compareToIgnoreCase(component2);
        }

        private boolean isInteger(String string) {
            return string.matches("\\d+");
        }
    }
}

