/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.AbstractDownloadableResource;
import com.atlassian.plugin.servlet.BaseFileServerServlet;
import com.atlassian.plugin.servlet.ResourceDownloadUtils;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadableClasspathResource
extends AbstractDownloadableResource {
    private static final Log log = LogFactory.getLog((Class)DownloadableClasspathResource.class);

    public DownloadableClasspathResource(BaseFileServerServlet servlet, Plugin plugin, ResourceLocation resourceDescriptor, String extraPath) {
        super(servlet, plugin, resourceDescriptor, extraPath);
    }

    public void serveResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (this.checkResourceNotModified(httpServletRequest, httpServletResponse)) {
            return;
        }
        log.debug((Object)("Serving: " + this));
        InputStream resourceStream = this.plugin.getResourceAsStream(this.getLocation());
        if (resourceStream != null) {
            httpServletResponse.setContentType(this.getContentType());
            ResourceDownloadUtils.serveFileImpl(httpServletResponse, resourceStream);
            try {
                resourceStream.close();
            }
            catch (IOException e) {
                log.error((Object)"Could not close input stream on resource:", (Throwable)e);
            }
        } else {
            log.info((Object)("Resource not found: " + this));
        }
    }
}

