/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.loaders;

import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.impl.DynamicPlugin;
import com.atlassian.plugin.loaders.PluginLoader;
import com.atlassian.plugin.loaders.classloading.DeploymentUnit;
import com.atlassian.plugin.loaders.classloading.PluginsClassLoader;
import com.atlassian.plugin.loaders.classloading.Scanner;
import com.atlassian.plugin.parsers.DescriptorParser;
import com.atlassian.plugin.parsers.DescriptorParserFactory;
import com.atlassian.plugin.parsers.XmlDescriptorParserFactory;
import com.atlassian.plugin.util.FileUtils;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassLoadingPluginLoader
implements PluginLoader {
    private static Log log = LogFactory.getLog((Class)ClassLoadingPluginLoader.class);
    private String fileNameToLoad;
    private Scanner scanner;
    private Map plugins;
    private DescriptorParserFactory descriptorParserFactory = new XmlDescriptorParserFactory();

    public ClassLoadingPluginLoader(File path) {
        this(path, "atlassian-plugin.xml");
    }

    public ClassLoadingPluginLoader(File path, String fileNameToLoad) {
        log.debug((Object)("Creating classloader for url " + path));
        this.scanner = new Scanner(path);
        this.fileNameToLoad = fileNameToLoad;
        this.plugins = new HashMap();
    }

    public Collection loadAllPlugins(ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        this.scanner.scan();
        Iterator iterator = this.scanner.getDeploymentUnits().iterator();
        while (iterator.hasNext()) {
            DeploymentUnit deploymentUnit = (DeploymentUnit)iterator.next();
            try {
                Plugin plugin = this.deployPluginFromUnit(deploymentUnit, moduleDescriptorFactory);
                this.plugins.put(deploymentUnit, plugin);
            }
            catch (PluginParseException e) {}
        }
        return this.plugins.values();
    }

    protected Plugin deployPluginFromUnit(DeploymentUnit deploymentUnit, ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        Plugin plugin = null;
        PluginsClassLoader loader = this.getPluginsClassLoader(deploymentUnit);
        URL pluginDescriptor = loader.getResource(this.fileNameToLoad);
        if (pluginDescriptor == null) {
            log.error((Object)("No descriptor found in classloader for : " + deploymentUnit));
        } else {
            InputStream is = loader.getResourceAsStream(this.fileNameToLoad);
            try {
                DescriptorParser parser = this.descriptorParserFactory.getInstance(is);
                plugin = parser.configurePlugin(moduleDescriptorFactory, new DynamicPlugin(deploymentUnit, loader));
            }
            catch (PluginParseException e) {
                log.error((Object)("Error loading descriptor for : " + deploymentUnit), (Throwable)((Object)e));
                loader.close();
                throw e;
            }
            finally {
                FileUtils.shutdownStream(is);
            }
        }
        return plugin;
    }

    private PluginsClassLoader getPluginsClassLoader(DeploymentUnit deploymentUnit) {
        return (PluginsClassLoader)this.scanner.getClassLoader(deploymentUnit);
    }

    public boolean supportsRemoval() {
        return true;
    }

    public boolean supportsAddition() {
        return true;
    }

    public Collection addFoundPlugins(ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        this.scanner.scan();
        ArrayList<Plugin> foundPlugins = new ArrayList<Plugin>();
        Iterator iterator = this.scanner.getDeploymentUnits().iterator();
        while (iterator.hasNext()) {
            DeploymentUnit deploymentUnit = (DeploymentUnit)iterator.next();
            if (this.plugins.containsKey(deploymentUnit)) continue;
            Plugin plugin = this.deployPluginFromUnit(deploymentUnit, moduleDescriptorFactory);
            this.plugins.put(deploymentUnit, plugin);
            foundPlugins.add(plugin);
        }
        return foundPlugins;
    }

    public void removePlugin(Plugin plugin) throws PluginException {
        if (plugin.isEnabled()) {
            throw new PluginException("Cannot remove an enabled plugin");
        }
        if (!plugin.isUninstallable()) {
            throw new PluginException("Cannot remove an uninstallable plugin: [" + plugin.getName() + "]");
        }
        Iterator iterator = this.plugins.keySet().iterator();
        DeploymentUnit deploymentUnit = null;
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (this.plugins.get(o) != plugin) continue;
            deploymentUnit = (DeploymentUnit)o;
            this.plugins.remove(deploymentUnit);
            break;
        }
        if (deploymentUnit == null) {
            throw new PluginException("This pluginLoader has no memory of deploying the plugin you are trying remove: [" + plugin.getName() + "]");
        }
        File pluginOnDisk = deploymentUnit.getPath();
        this.scanner.undeploy(pluginOnDisk);
        try {
            if (!pluginOnDisk.delete()) {
                throw new PluginException("Could not delete plugin [" + plugin.getName() + "].");
            }
        }
        catch (SecurityException e) {
            throw new PluginException(e);
        }
    }

    public void shutDown() {
        this.scanner.undeployAll();
    }
}

