/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin;

import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginInstaller;
import com.atlassian.plugin.PluginJar;
import com.atlassian.plugin.PluginManager;
import com.atlassian.plugin.PluginManagerState;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.PluginStateStore;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.UnloadableModuleDescriptor;
import com.atlassian.plugin.descriptors.UnloadableModuleDescriptorFactory;
import com.atlassian.plugin.impl.UnloadablePlugin;
import com.atlassian.plugin.impl.UnloadablePluginFactory;
import com.atlassian.plugin.loaders.PluginLoader;
import com.atlassian.plugin.parsers.DescriptorParser;
import com.atlassian.plugin.parsers.DescriptorParserFactory;
import com.atlassian.plugin.parsers.XmlDescriptorParserFactory;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultPluginManager
implements PluginManager {
    private static final Log log = LogFactory.getLog((Class)DefaultPluginManager.class);
    private final List pluginLoaders;
    private final PluginStateStore store;
    private ModuleDescriptorFactory moduleDescriptorFactory;
    private HashMap plugins = new HashMap();
    private DescriptorParserFactory descriptorParserFactory = new XmlDescriptorParserFactory();
    private PluginInstaller pluginInstaller;
    private HashMap pluginToPluginLoader = new HashMap();

    public DefaultPluginManager(PluginStateStore store, List pluginLoaders, ModuleDescriptorFactory moduleDescriptorFactory) {
        this.pluginLoaders = pluginLoaders;
        this.store = store;
        this.moduleDescriptorFactory = moduleDescriptorFactory;
    }

    public void init() throws PluginParseException {
        Iterator iterator = this.pluginLoaders.iterator();
        while (iterator.hasNext()) {
            PluginLoader loader = (PluginLoader)iterator.next();
            if (loader == null) continue;
            Iterator pluginIterator = loader.loadAllPlugins(this.moduleDescriptorFactory).iterator();
            while (pluginIterator.hasNext()) {
                this.addPlugin(loader, (Plugin)pluginIterator.next());
            }
        }
    }

    public void setPluginInstaller(PluginInstaller pluginInstaller) {
        this.pluginInstaller = pluginInstaller;
    }

    protected final PluginStateStore getStore() {
        return this.store;
    }

    public String installPlugin(PluginJar pluginJar) throws PluginParseException {
        this.validatePlugin(pluginJar);
        DescriptorParser descriptorParser = this.descriptorParserFactory.getInstance(pluginJar.getFile("atlassian-plugin.xml"));
        String key = descriptorParser.getKey();
        this.pluginInstaller.installPlugin(key, pluginJar);
        this.scanForNewPlugins();
        return key;
    }

    private void validatePlugin(PluginJar pluginJar) throws PluginParseException {
        InputStream descriptorStream = pluginJar.getFile("atlassian-plugin.xml");
        DescriptorParser descriptorParser = this.descriptorParserFactory.getInstance(descriptorStream);
        if (descriptorParser.getKey() == null) {
            throw new PluginParseException("Plugin key could not be found in atlassian-plugin.xml");
        }
    }

    public int scanForNewPlugins() throws PluginParseException {
        int numberFound = 0;
        Iterator iterator = this.pluginLoaders.iterator();
        while (iterator.hasNext()) {
            PluginLoader loader = (PluginLoader)iterator.next();
            if (loader == null || !loader.supportsAddition()) continue;
            Collection addedPlugins = loader.addFoundPlugins(this.moduleDescriptorFactory);
            Iterator iterator1 = addedPlugins.iterator();
            while (iterator1.hasNext()) {
                Plugin newPlugin = (Plugin)iterator1.next();
                ++numberFound;
                this.addPlugin(loader, newPlugin);
            }
        }
        return numberFound;
    }

    public void uninstall(Plugin plugin) throws PluginException {
        this.unloadPlugin(plugin);
        this.removeStateFromStore(this.getStore(), plugin);
    }

    protected void removeStateFromStore(PluginStateStore stateStore, Plugin plugin) {
        PluginManagerState currentState = stateStore.loadPluginState();
        currentState.removeState(plugin.getKey());
        stateStore.savePluginState(currentState);
    }

    protected void unloadPlugin(Plugin plugin) throws PluginException {
        if (!plugin.isUninstallable()) {
            throw new PluginException("Plugin is not uninstallable: " + plugin.getKey());
        }
        PluginLoader loader = (PluginLoader)this.pluginToPluginLoader.get(plugin);
        if (loader != null && !loader.supportsRemoval()) {
            throw new PluginException("Not uninstalling plugin - loader doesn't allow removal. Plugin: " + plugin.getKey());
        }
        if (this.isPluginEnabled(plugin.getKey())) {
            this.notifyPluginDisabled(plugin);
        }
        this.notifyUninstallPlugin(plugin);
        if (loader != null) {
            this.removePluginFromLoader(plugin);
        }
        this.plugins.remove(plugin.getKey());
    }

    private void removePluginFromLoader(Plugin plugin) throws PluginException {
        if (plugin.isDeleteable()) {
            PluginLoader pluginLoader = (PluginLoader)this.pluginToPluginLoader.get(plugin);
            pluginLoader.removePlugin(plugin);
        }
        this.pluginToPluginLoader.remove(plugin);
    }

    protected void notifyUninstallPlugin(Plugin plugin) {
        Iterator it = plugin.getModuleDescriptors().iterator();
        while (it.hasNext()) {
            ModuleDescriptor descriptor = (ModuleDescriptor)it.next();
            descriptor.destroy(plugin);
        }
    }

    protected PluginManagerState getState() {
        return this.getStore().loadPluginState();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    protected void addPlugin(PluginLoader loader, Plugin plugin) throws PluginParseException {
        if (this.plugins.containsKey(plugin.getKey())) {
            Plugin existingPlugin = (Plugin)this.plugins.get(plugin.getKey());
            if (plugin.compareTo(existingPlugin) <= 0) {
                if (!log.isDebugEnabled()) return;
                log.debug((Object)("Duplicate plugin found (installed version is the same or newer): '" + plugin.getKey() + "'"));
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("We found a newer '" + plugin.getKey() + "'"));
            }
            try {
                log.info((Object)("Unloading " + existingPlugin.getName() + " to upgrade."));
                this.updatePlugin(existingPlugin, plugin);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Older '" + plugin.getKey() + "' unloaded."));
                }
            }
            catch (PluginException e) {
                throw new PluginParseException("Duplicate plugin found (installed version is older) and could not be unloaded: '" + plugin.getKey() + "'");
            }
        }
        this.plugins.put(plugin.getKey(), plugin);
        this.enablePluginModules(plugin);
        this.pluginToPluginLoader.put(plugin, loader);
    }

    protected void updatePlugin(Plugin oldPlugin, Plugin newPlugin) throws PluginException {
        if (!oldPlugin.getKey().equals(newPlugin.getKey())) {
            throw new IllegalArgumentException("New plugin must have the same key as the old plugin");
        }
        Map oldPluginState = this.getState().getPluginStateMap(oldPlugin);
        this.uninstall(oldPlugin);
        final HashSet<String> newModuleKeys = new HashSet<String>();
        newModuleKeys.add(newPlugin.getKey());
        Iterator moduleIter = newPlugin.getModuleDescriptors().iterator();
        while (moduleIter.hasNext()) {
            ModuleDescriptor moduleDescriptor = (ModuleDescriptor)moduleIter.next();
            newModuleKeys.add(moduleDescriptor.getKey());
        }
        CollectionUtils.filter(oldPluginState.keySet(), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                String key = (String)object;
                return newModuleKeys.contains(key);
            }
        });
        PluginManagerState currentState = this.getState();
        currentState.getMap().putAll(oldPluginState);
        this.getStore().savePluginState(currentState);
    }

    public Collection getPlugins() {
        return this.plugins.values();
    }

    public Collection getEnabledPlugins() {
        ArrayList<Plugin> result = new ArrayList<Plugin>();
        Iterator iterator = this.plugins.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Plugin p = this.getEnabledPlugin(key);
            if (p == null) continue;
            result.add(p);
        }
        return result;
    }

    public Plugin getPlugin(String key) {
        return (Plugin)this.plugins.get(key);
    }

    public Plugin getEnabledPlugin(String pluginKey) {
        if (!this.isPluginEnabled(pluginKey)) {
            return null;
        }
        return this.getPlugin(pluginKey);
    }

    public ModuleDescriptor getPluginModule(String completeKey) {
        ModuleCompleteKey key = new ModuleCompleteKey(completeKey);
        Plugin plugin = this.getPlugin(key.getPluginKey());
        if (plugin == null) {
            return null;
        }
        return plugin.getModuleDescriptor(key.getModuleKey());
    }

    public ModuleDescriptor getEnabledPluginModule(String completeKey) {
        ModuleCompleteKey key = new ModuleCompleteKey(completeKey);
        if (!this.isPluginModuleEnabled(completeKey)) {
            return null;
        }
        return this.getEnabledPlugin(key.getPluginKey()).getModuleDescriptor(key.getModuleKey());
    }

    public List getEnabledModulesByClass(Class moduleClass) {
        LinkedList<Object> result = new LinkedList<Object>();
        Iterator iterator = this.plugins.values().iterator();
        while (iterator.hasNext()) {
            Plugin plugin = (Plugin)iterator.next();
            Iterator iterator1 = plugin.getModuleDescriptors().iterator();
            while (iterator1.hasNext()) {
                ModuleDescriptor moduleDescriptor = (ModuleDescriptor)iterator1.next();
                Class moduleDescClass = moduleDescriptor.getModuleClass();
                if (moduleDescClass == null || !moduleClass.isAssignableFrom(moduleDescClass) || !this.isPluginModuleEnabled(moduleDescriptor.getCompleteKey())) continue;
                try {
                    Object module = moduleDescriptor.getModule();
                    if (module == null) continue;
                    result.add(module);
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
        }
        return result;
    }

    public void enablePlugin(String key) {
        if (key == null) {
            throw new IllegalArgumentException("You must specify a plugin key to disable.");
        }
        if (!this.plugins.containsKey(key)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("No plugin was found for key '" + key + "'. Not enabling."));
            }
            return;
        }
        Plugin plugin = (Plugin)this.plugins.get(key);
        if (!plugin.getPluginInformation().satisfiesMinJavaVersion()) {
            log.error((Object)("Minimum Java version of '" + plugin.getPluginInformation().getMinJavaVersion() + "' was not satisfied for module '" + key + "'. Not enabling."));
            return;
        }
        this.enablePluginState(plugin, this.getStore());
        this.notifyPluginEnabled(plugin);
    }

    protected void enablePluginState(Plugin plugin, PluginStateStore stateStore) {
        PluginManagerState currentState = stateStore.loadPluginState();
        String key = plugin.getKey();
        if (!plugin.isEnabledByDefault()) {
            currentState.setState(key, Boolean.TRUE);
        } else {
            currentState.removeState(key);
        }
        stateStore.savePluginState(currentState);
    }

    protected void notifyPluginEnabled(Plugin plugin) {
        this.enablePluginModules(plugin);
    }

    private void enablePluginModules(Plugin plugin) {
        Iterator it = plugin.getModuleDescriptors().iterator();
        while (it.hasNext()) {
            ModuleDescriptor descriptor = (ModuleDescriptor)it.next();
            if (!(descriptor instanceof StateAware)) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("ModuleDescriptor '" + descriptor.getName() + "' is not StateAware. No need to enable."));
                continue;
            }
            if (!this.isPluginModuleEnabled(descriptor.getCompleteKey())) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Plugin module is disabled, so not enabling ModuleDescriptor '" + descriptor.getName() + "'."));
                continue;
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Enabling " + descriptor.getKey()));
                }
                ((StateAware)((Object)descriptor)).enabled();
            }
            catch (Throwable exception) {
                log.error((Object)("There was an error loading the descriptor '" + descriptor.getName() + "' of plugin '" + plugin.getKey() + "'. Disabling."), exception);
                this.replacePluginWithUnloadablePlugin(plugin, descriptor, exception);
            }
        }
    }

    public void disablePlugin(String key) {
        if (key == null) {
            throw new IllegalArgumentException("You must specify a plugin key to disable.");
        }
        if (!this.plugins.containsKey(key)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("No plugin was found for key '" + key + "'. Not disabling."));
            }
            return;
        }
        Plugin plugin = (Plugin)this.plugins.get(key);
        this.notifyPluginDisabled(plugin);
        this.disablePluginState(plugin, this.getStore());
    }

    protected void disablePluginState(Plugin plugin, PluginStateStore stateStore) {
        String key = plugin.getKey();
        PluginManagerState currentState = stateStore.loadPluginState();
        if (plugin.isEnabledByDefault()) {
            currentState.setState(key, Boolean.FALSE);
        } else {
            currentState.removeState(key);
        }
        stateStore.savePluginState(currentState);
    }

    protected List getEnabledStateAwareModuleKeys(Plugin plugin) {
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList moduleDescriptors = new ArrayList(plugin.getModuleDescriptors());
        Collections.reverse(moduleDescriptors);
        Iterator it = moduleDescriptors.iterator();
        while (it.hasNext()) {
            ModuleDescriptor md = (ModuleDescriptor)it.next();
            if (!(md instanceof StateAware) || !this.isPluginModuleEnabled(md.getCompleteKey())) continue;
            keys.add(md.getCompleteKey());
        }
        return keys;
    }

    protected void notifyPluginDisabled(Plugin plugin) {
        List keysToDisable = this.getEnabledStateAwareModuleKeys(plugin);
        Iterator it = keysToDisable.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            StateAware descriptor = (StateAware)((Object)this.getPluginModule(key));
            descriptor.disabled();
        }
    }

    public void disablePluginModule(String completeKey) {
        if (completeKey == null) {
            throw new IllegalArgumentException("You must specify a plugin module key to disable.");
        }
        ModuleDescriptor module = this.getPluginModule(completeKey);
        if (module == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Returned module for key '" + completeKey + "' was null. Not disabling."));
            }
            return;
        }
        this.disablePluginModuleState(module, this.getStore());
        this.notifyModuleDisabled(module);
    }

    protected void disablePluginModuleState(ModuleDescriptor module, PluginStateStore stateStore) {
        String completeKey = module.getCompleteKey();
        PluginManagerState currentState = stateStore.loadPluginState();
        if (module.isEnabledByDefault()) {
            currentState.setState(completeKey, Boolean.FALSE);
        } else {
            currentState.removeState(completeKey);
        }
        stateStore.savePluginState(currentState);
    }

    protected void notifyModuleDisabled(ModuleDescriptor module) {
        if (module instanceof StateAware) {
            ((StateAware)((Object)module)).disabled();
        }
    }

    public void enablePluginModule(String completeKey) {
        if (completeKey == null) {
            throw new IllegalArgumentException("You must specify a plugin module key to disable.");
        }
        ModuleDescriptor module = this.getPluginModule(completeKey);
        if (module == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Returned module for key '" + completeKey + "' was null. Not enabling."));
            }
            return;
        }
        if (!module.satisfiesMinJavaVersion()) {
            log.error((Object)("Minimum Java version of '" + module.getMinJavaVersion() + "' was not satisfied for module '" + completeKey + "'. Not enabling."));
            return;
        }
        this.enablePluginModuleState(module, this.getStore());
        this.notifyModuleEnabled(module);
    }

    protected void enablePluginModuleState(ModuleDescriptor module, PluginStateStore stateStore) {
        String completeKey = module.getCompleteKey();
        PluginManagerState currentState = stateStore.loadPluginState();
        if (!module.isEnabledByDefault()) {
            currentState.setState(completeKey, Boolean.TRUE);
        } else {
            currentState.removeState(completeKey);
        }
        stateStore.savePluginState(currentState);
    }

    protected void notifyModuleEnabled(ModuleDescriptor module) {
        if (module instanceof StateAware) {
            ((StateAware)((Object)module)).enabled();
        }
    }

    public boolean isPluginModuleEnabled(String completeKey) {
        ModuleCompleteKey key = new ModuleCompleteKey(completeKey);
        ModuleDescriptor pluginModule = this.getPluginModule(completeKey);
        return this.isPluginEnabled(key.getPluginKey()) && pluginModule != null && this.getState().isEnabled(pluginModule);
    }

    public boolean isPluginEnabled(String key) {
        return this.plugins.containsKey(key) && this.getState().isEnabled((Plugin)this.plugins.get(key));
    }

    public List getEnabledModuleDescriptorsByClass(Class descriptorClazz) {
        LinkedList<ModuleDescriptor> result = new LinkedList<ModuleDescriptor>();
        Iterator iterator = this.plugins.values().iterator();
        while (iterator.hasNext()) {
            Plugin plugin = (Plugin)iterator.next();
            if (!this.isPluginEnabled(plugin.getKey())) continue;
            Iterator iterator1 = plugin.getModuleDescriptors().iterator();
            while (iterator1.hasNext()) {
                ModuleDescriptor module = (ModuleDescriptor)iterator1.next();
                if (!descriptorClazz.isInstance(module) || !this.isPluginModuleEnabled(module.getCompleteKey())) continue;
                result.add(module);
            }
        }
        return result;
    }

    public List getEnabledModuleDescriptorsByType(String type) throws PluginParseException, IllegalArgumentException {
        Class descriptorClazz = this.moduleDescriptorFactory.getModuleDescriptorClass(type);
        if (descriptorClazz == null) {
            throw new IllegalArgumentException("No module descriptor of type: " + type + " found.");
        }
        return this.getEnabledModuleDescriptorsByClass(descriptorClazz);
    }

    public InputStream getDynamicResourceAsStream(String name) {
        Iterator iterator = this.plugins.values().iterator();
        while (iterator.hasNext()) {
            InputStream is;
            Plugin plugin = (Plugin)iterator.next();
            if (!plugin.isDynamicallyLoaded() || !this.isPluginEnabled(plugin.getKey()) || (is = plugin.getResourceAsStream(name)) == null) continue;
            return is;
        }
        return null;
    }

    public InputStream getPluginResourceAsStream(String pluginKey, String resourcePath) {
        Plugin plugin = this.getEnabledPlugin(pluginKey);
        if (plugin == null) {
            log.error((Object)("Attempted to retreive resource " + resourcePath + " for non-existent or inactive plugin " + pluginKey));
            return null;
        }
        return plugin.getResourceAsStream(resourcePath);
    }

    private UnloadablePlugin replacePluginWithUnloadablePlugin(Plugin plugin, ModuleDescriptor descriptor, Throwable throwable) {
        UnloadableModuleDescriptor unloadableDescriptor = UnloadableModuleDescriptorFactory.createUnloadableModuleDescriptor(plugin, descriptor, throwable);
        UnloadablePlugin unloadablePlugin = UnloadablePluginFactory.createUnloadablePlugin(plugin, unloadableDescriptor);
        unloadablePlugin.setUninstallable(plugin.isUninstallable());
        unloadablePlugin.setDeletable(plugin.isDeleteable());
        this.plugins.put(plugin.getKey(), unloadablePlugin);
        this.disablePluginState(plugin, this.getStore());
        return unloadablePlugin;
    }

    public boolean isSystemPlugin(String key) {
        Plugin plugin = this.getPlugin(key);
        return plugin != null && plugin.isSystemPlugin();
    }

    public void setDescriptorParserFactory(DescriptorParserFactory descriptorParserFactory) {
        this.descriptorParserFactory = descriptorParserFactory;
    }
}

