/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.impl.snapshot.resource.strategy.stream;

import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.impl.helpers.FileOperations;
import com.atlassian.plugin.webresource.impl.snapshot.Bundle;
import com.atlassian.plugin.webresource.impl.snapshot.resource.strategy.stream.StreamStrategy;
import com.atlassian.plugin.webresource.util.WebResourceKeyHelper;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.webresource.api.assembler.resource.CompleteWebResourceKey;
import java.io.InputStream;
import java.nio.file.Path;

public class PluginSharedHomeStreamStrategy
implements StreamStrategy {
    private final FileOperations fileOperations;
    private final WebResourceIntegration webResourceIntegration;
    private final CompleteWebResourceKey bundleKey;

    public PluginSharedHomeStreamStrategy(FileOperations fileOperations, WebResourceIntegration webResourceIntegration, Bundle bundle) {
        this.fileOperations = fileOperations;
        this.webResourceIntegration = webResourceIntegration;
        this.bundleKey = WebResourceKeyHelper.createWebResourceKey(bundle.getKey()).orElseThrow();
    }

    @Override
    public InputStream getInputStream(String path) {
        Path normalizedResolutionRoot = this.getResolutionRoot(this.webResourceIntegration.getPluginAccessor().getEnabledPlugin(this.bundleKey.getPluginKey()).getKey()).normalize();
        Path resolvedNormalizedPath = normalizedResolutionRoot.resolve(path).normalize();
        if (!resolvedNormalizedPath.startsWith(normalizedResolutionRoot)) {
            throw new IllegalArgumentException("Invalid sharedPluginHome web resource definition");
        }
        path = resolvedNormalizedPath.toString();
        if (this.fileOperations.exists(path)) {
            try {
                return this.fileOperations.createInputStream(path);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to read " + path + " within " + normalizedResolutionRoot + " : " + e);
            }
        }
        return null;
    }

    private Path getResolutionRoot(String pluginKey) {
        ApplicationProperties applicationProperties = this.webResourceIntegration.getApplicationProperties();
        Path designatedHome = applicationProperties.getSharedHomeDirectory().orElse((Path)applicationProperties.getLocalHomeDirectory().orElseThrow(() -> new RuntimeException("Unable to determine home directory for pluginSharedHome resolution.")));
        return designatedHome.resolve("web-resources").resolve(pluginKey);
    }
}

