package com.atlassian.plugin.webresource.impl.snapshot.resource.strategy.stream;

import com.atlassian.plugin.webresource.WebResourceIntegration;

import java.io.InputStream;

public class ESModuleStreamStrategy implements StreamStrategy {
    private final WebResourceIntegration webResourceIntegration;
    private final String pluginKey;


    ESModuleStreamStrategy(WebResourceIntegration webResourceIntegration, String pluginKey) {
        this.webResourceIntegration = webResourceIntegration;
        this.pluginKey = pluginKey;
    }

    @Override
    public InputStream getInputStream(String path) {
        // TODO: This plugin Key seems like it can be retrieved from Bundle, check it out.
        return webResourceIntegration.getPluginAccessor().getPlugin(pluginKey).getResourceAsStream(path);
    }
}
