package com.atlassian.plugin.webresource.impl.snapshot.resource;

import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.webresource.impl.snapshot.Context;
import com.atlassian.plugin.webresource.impl.snapshot.resource.strategy.contentprovider.ContentProviderStrategy;
import com.atlassian.plugin.webresource.impl.snapshot.resource.strategy.contenttype.ContentTypeStrategy;
import com.atlassian.plugin.webresource.impl.snapshot.resource.strategy.path.PathStrategy;


/**
 * Virtual resource for Context, needed to add `require` statement for modules.
 *
 * @since v3.4.4
 */
public class ContextResource extends Resource {
    private final Context contextParent;

    ContextResource(Context parent, ResourceLocation resourceLocation, ContentTypeStrategy contentTypeStrategy, PathStrategy pathStrategy, ContentProviderStrategy contentProviderStrategy) {
        super(
                parent,
                resourceLocation,
                "js",
                "js",
                contentTypeStrategy,
                null,
                pathStrategy,
                contentProviderStrategy
        );
        this.contextParent = parent;
    }

    @Override
    public boolean isTransformable() {
        return false;
    }
}
