/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;

public class ResourceUtils {
    public static final String STATIC_HASH = "_statichash";

    public static String getType(@Nonnull String path) {
        int index = path.lastIndexOf(46);
        if (index > -1 && index < path.length()) {
            return path.substring(index + 1).toLowerCase();
        }
        return "";
    }

    public static String getBasename(@Nonnull String path) {
        int index = path.lastIndexOf(46);
        if (index > -1 && index < path.length()) {
            return path.substring(0, index);
        }
        return path;
    }

    public static Map<String, String> getQueryParameters(HttpServletRequest request) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        Map parameters = request.getParameterMap();
        for (Map.Entry entry : parameters.entrySet()) {
            if (entry.getValue() == null || ((String[])entry.getValue()).length <= 0) continue;
            result.put((String)entry.getKey(), ((String[])entry.getValue())[0]);
        }
        String hash = (String)request.getAttribute(STATIC_HASH);
        if (hash != null) {
            result.put(STATIC_HASH, hash);
        }
        return result;
    }

    public static boolean canRequestedResourcesContentBeAssumedConstant(Map<String, String> params) {
        boolean nocache = "false".equals(params.get("cache"));
        boolean nohash = !params.containsKey(STATIC_HASH);
        return !nohash && !nocache;
    }
}

