/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.legacy;

import com.atlassian.plugin.webresource.impl.RequestCache;
import com.atlassian.plugin.webresource.impl.UrlBuildingStrategy;
import com.atlassian.plugin.webresource.impl.config.Config;
import com.atlassian.plugin.webresource.impl.helpers.UrlGenerationHelpers;
import com.atlassian.plugin.webresource.legacy.BatchPluginResource;
import com.atlassian.plugin.webresource.legacy.ContextBatchPluginResource;
import com.atlassian.plugin.webresource.legacy.DefaultResourceDependencyResolver;
import com.atlassian.plugin.webresource.legacy.InclusionState;
import com.atlassian.plugin.webresource.legacy.PluginResource;
import com.atlassian.plugin.webresource.legacy.PluginResourceLocatorImpl;
import com.atlassian.plugin.webresource.legacy.ResourceRequirer;
import com.atlassian.plugin.webresource.legacy.SuperBatchPluginResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

public class LegacyUrlGenerationHelpers {
    public static Resolved calculateBatches(RequestCache requestCache, UrlBuildingStrategy urlBuildingStrategy, LinkedHashSet<String> allIncluded, LinkedHashSet<String> allExcluded, boolean includeDependenciesForFailedUrlReadingConditions) {
        LinkedHashSet<String> excluded;
        ArrayList<String> included;
        String prefix = "_context:";
        LinkedHashSet<String> requiredContexts = new LinkedHashSet<String>();
        LinkedHashSet<String> requiredWebResources = new LinkedHashSet<String>();
        boolean isSuperBatchEnabled = false;
        for (String key : allIncluded) {
            if (Config.isContextKey(key)) {
                if ("_context:_super".equals(key)) {
                    isSuperBatchEnabled = true;
                    continue;
                }
                requiredContexts.add(key.replace(prefix, ""));
                continue;
            }
            requiredWebResources.add(key);
        }
        LinkedHashSet<String> excludedContexts = new LinkedHashSet<String>();
        LinkedHashSet<String> excludedWebResources = new LinkedHashSet<String>();
        boolean isSuperBatchHasBeenEscluded = false;
        boolean isSyncBatchExcluded = false;
        for (String key : allExcluded) {
            if ("_context:_super".equals(key)) {
                isSuperBatchHasBeenEscluded = true;
                continue;
            }
            if (Config.isContextKey(key)) {
                excludedContexts.add(key.replace(prefix, ""));
                if (!"_context:_sync".equals(key)) continue;
                isSyncBatchExcluded = true;
                continue;
            }
            excludedWebResources.add(key);
        }
        Config config = requestCache.getGlobals().getConfig();
        ArrayList<String> superBatchKeys = new ArrayList<String>(config.getBeforeAllResources());
        superBatchKeys.addAll(config.getBatchingConfiguration().getSuperBatchModuleCompleteKeys());
        DefaultResourceDependencyResolver legacyDependencyResolver = new DefaultResourceDependencyResolver(requestCache.getGlobals(), config.getIntegration(), isSuperBatchEnabled |= isSuperBatchHasBeenEscluded, superBatchKeys);
        PluginResourceLocatorImpl legacyResourceLocator = new PluginResourceLocatorImpl(config.getIntegration());
        ResourceRequirer resourceRequirer = new ResourceRequirer(config.getIntegration(), legacyResourceLocator, legacyDependencyResolver, config.resplitMergedContextBatchesForThisRequest(), isSuperBatchEnabled, includeDependenciesForFailedUrlReadingConditions);
        InclusionState inclusionState = new InclusionState(isSuperBatchHasBeenEscluded, excludedWebResources, excludedContexts);
        Collection<PluginResource> resources = resourceRequirer.includeResources(requestCache, urlBuildingStrategy, requiredWebResources, requiredContexts, inclusionState);
        ArrayList<UrlGenerationHelpers.ContextBatchKey> contextBatchKeys = new ArrayList<UrlGenerationHelpers.ContextBatchKey>();
        ArrayList<String> webResourceBatchKeys = new ArrayList<String>();
        boolean hasSuperbatch = false;
        for (PluginResource pluginResource : resources) {
            if (!(pluginResource instanceof SuperBatchPluginResource)) continue;
            included = new ArrayList<String>();
            included.add("_context:_super");
            excluded = new LinkedHashSet<String>();
            if (isSyncBatchExcluded) {
                excluded.add("_context:_sync");
            }
            contextBatchKeys.add(new UrlGenerationHelpers.ContextBatchKey(included, excluded));
            hasSuperbatch = true;
            break;
        }
        for (PluginResource pluginResource : resources) {
            if (pluginResource instanceof ContextBatchPluginResource) {
                included = new ArrayList();
                excluded = new LinkedHashSet();
                ContextBatchPluginResource contextBatchPluginResource = (ContextBatchPluginResource)pluginResource;
                for (String key : contextBatchPluginResource.getContexts()) {
                    included.add("_context:" + key);
                }
                if (isSuperBatchHasBeenEscluded || hasSuperbatch && inclusionState.superbatch) {
                    excluded.add("_context:_super");
                }
                for (String key : contextBatchPluginResource.getExcludedContexts()) {
                    excluded.add("_context:" + key);
                }
                contextBatchKeys.add(new UrlGenerationHelpers.ContextBatchKey(included, excluded));
            }
            if (!(pluginResource instanceof BatchPluginResource)) continue;
            BatchPluginResource batchPluginResource = (BatchPluginResource)pluginResource;
            webResourceBatchKeys.add(batchPluginResource.getModuleCompleteKey());
        }
        LinkedHashSet<String> excludedResolved = new LinkedHashSet<String>();
        if (isSuperBatchHasBeenEscluded || hasSuperbatch && inclusionState.superbatch) {
            excludedResolved.add("_context:_super");
        }
        for (String key : inclusionState.contexts) {
            if ("_super".equals(key)) continue;
            excludedResolved.add("_context:" + key);
        }
        for (String key : inclusionState.webresources) {
            excludedResolved.add(key);
        }
        return new Resolved(contextBatchKeys, webResourceBatchKeys, excludedResolved);
    }

    public static class Resolved {
        public final List<UrlGenerationHelpers.ContextBatchKey> contextBatchKeys;
        public final List<String> webResourceBatchKeys;
        public final LinkedHashSet<String> excludedResolved;

        public Resolved(List<UrlGenerationHelpers.ContextBatchKey> contextBatchKeys, List<String> webResourceBatchKeys, LinkedHashSet<String> excludedResolved) {
            this.contextBatchKeys = contextBatchKeys;
            this.webResourceBatchKeys = webResourceBatchKeys;
            this.excludedResolved = excludedResolved;
        }
    }
}

