package com.atlassian.plugin.webresource.impl.snapshot;

import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.webresource.impl.config.Config;

import java.util.HashMap;

/**
 * Virtual resource for JS Module, stub to fit in existing API.
 *
 * @since v3.4.4
 */
public class ModuleResource extends Resource {
    private final String pluginKey;
    private final String type;

    public ModuleResource(WebModule parent, String pluginKey, String filePath, String type) {
        super(parent, new ResourceLocation(filePath, filePath, type, null, null, new HashMap<>()), type, type);
        this.type = type;
        this.pluginKey = pluginKey;
    }

    public String getContentType() {
        switch (type) {
            case Config.CSS_TYPE:
                return Config.CSS_CONTENT_TYPE;
            case Config.JS_TYPE:
                return Config.JS_CONTENT_TYPE;
            default:
                return super.getContentType();
        }
    }

    /**
     * Plugin key this resource belongs to.
     */
    public String getPluginKey() {
        return pluginKey;
    }
}
