/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.assembler;

import com.atlassian.json.marshal.Jsonable;
import com.atlassian.json.marshal.wrapped.JsonableBoolean;
import com.atlassian.json.marshal.wrapped.JsonableNumber;
import com.atlassian.json.marshal.wrapped.JsonableString;
import com.atlassian.plugin.webresource.assembler.DefaultWebResourceSet;
import com.atlassian.plugin.webresource.bigpipe.BigPipe;
import com.atlassian.plugin.webresource.bigpipe.KeyedValue;
import com.atlassian.plugin.webresource.data.DefaultPluginDataResource;
import com.atlassian.plugin.webresource.impl.Globals;
import com.atlassian.plugin.webresource.impl.RequestState;
import com.atlassian.plugin.webresource.impl.config.Config;
import com.atlassian.plugin.webresource.impl.helpers.Helpers;
import com.atlassian.plugin.webresource.impl.helpers.UrlGenerationHelpers;
import com.atlassian.plugin.webresource.impl.snapshot.RootPage;
import com.atlassian.plugin.webresource.impl.support.Support;
import com.atlassian.plugin.webresource.impl.support.Tuple;
import com.atlassian.plugin.webresource.prebake.PrebakeWebResourceAssembler;
import com.atlassian.webresource.api.assembler.AssembledResources;
import com.atlassian.webresource.api.assembler.RequiredData;
import com.atlassian.webresource.api.assembler.RequiredResources;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import com.atlassian.webresource.api.assembler.WebResourceSet;
import com.atlassian.webresource.api.data.PluginDataResource;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultWebResourceAssembler
implements PrebakeWebResourceAssembler {
    private static Logger LOG = LoggerFactory.getLogger(DefaultWebResourceAssembler.class);
    private final RequestState requestState;
    private final AssembledResources assembledResourcesStub;
    private final RequiredResources requiredResourcesStub;
    private final RequiredData requiredDataStub;
    private final Config config;
    private final Globals globals;

    public DefaultWebResourceAssembler(final RequestState requestState, final Globals globals) {
        this.requestState = requestState;
        this.config = globals.getConfig();
        this.globals = globals;
        this.assembledResourcesStub = new AssembledResources(){

            public WebResourceSet drainIncludedResources() {
                return this.drainOrPoll(false);
            }

            public WebResourceSet pollIncludedResources() {
                return this.drainOrPoll(true);
            }

            private WebResourceSet drainOrPoll(boolean blockOnBigPipe) {
                Tuple<DefaultWebResourceSet, LinkedHashSet<String>> resolved = this.resolve(true, blockOnBigPipe);
                requestState.clearIncludedAndUpdateExcluded(resolved.getLast());
                return resolved.getFirst();
            }

            public WebResourceSet peek() {
                return this.resolve(false, false).getFirst();
            }

            private Tuple<DefaultWebResourceSet, LinkedHashSet<String>> resolve(boolean drainBigPipe, boolean blockOnBigPipe) {
                UrlGenerationHelpers.Resolved resolved = Helpers.resolve(requestState);
                LinkedList<PluginDataResource> pluginDataResources = new LinkedList<PluginDataResource>();
                for (Map.Entry<String, Jsonable> entry : resolved.data.entrySet()) {
                    pluginDataResources.add(new DefaultPluginDataResource(entry.getKey(), entry.getValue()));
                }
                if (drainBigPipe) {
                    for (KeyedValue keyedValue : this.drainBigPipe(blockOnBigPipe)) {
                        Optional<Jsonable> v = keyedValue.value().isRight() ? Optional.of(keyedValue.value().right().get()) : Optional.empty();
                        pluginDataResources.add(new DefaultPluginDataResource((String)keyedValue.key(), v));
                    }
                }
                boolean pipeComplete = requestState.getBigPipe().isComplete();
                return new Tuple<DefaultWebResourceSet, LinkedHashSet<String>>(new DefaultWebResourceSet(requestState, pluginDataResources, resolved.urls, pipeComplete, DefaultWebResourceAssembler.this.config), resolved.excludedResolved);
            }

            private Iterable<KeyedValue<String, Jsonable>> drainBigPipe(boolean blockOnBigPipe) {
                long waitForMs = requestState.getBigPipeDeadline() - System.currentTimeMillis();
                boolean exceededDeadline = waitForMs <= 0L;
                BigPipe bigPipe = requestState.getBigPipe();
                if (exceededDeadline) {
                    return bigPipe.forceCompleteAll();
                }
                if (blockOnBigPipe && !bigPipe.isComplete()) {
                    try {
                        return bigPipe.waitForContent(waitForMs, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        LOG.info("Interrupted while waiting for bigpipe", (Throwable)e);
                        return Collections.emptyList();
                    }
                }
                return bigPipe.getAvailableContent();
            }
        };
        this.requiredResourcesStub = new RequiredResources(){

            public RequiredResources requireWebResource(String completeKey) {
                if (!Config.isWebResourceKey(completeKey)) {
                    Support.LOGGER.warn("requiring something that doesn't look like the web resource \"" + completeKey + "\", it will be ignored.");
                    return this;
                }
                requestState.getIncluded().add(completeKey);
                return this;
            }

            public RequiredResources requireModule(String name) {
                if (Config.isWebResourceKey(name)) {
                    Support.LOGGER.warn("requiring web resource \"" + name + "\" as a module, it will be ignored.");
                    return this;
                }
                requestState.getIncluded().add(name);
                return this;
            }

            public RequiredResources requireContext(String context) {
                requestState.getIncluded().add("_context:" + context);
                return this;
            }

            public RequiredResources exclude(Set<String> excludeWebResources, Set<String> excludeContexts) {
                excludeWebResources = null == excludeWebResources ? Collections.emptySet() : Sets.newHashSet(excludeWebResources);
                excludeContexts = null == excludeContexts ? Sets.newHashSet() : Sets.newHashSet(excludeContexts);
                LinkedHashSet<String> exclude = new LinkedHashSet<String>();
                for (String context : excludeContexts) {
                    exclude.add("_context:" + context);
                }
                exclude.addAll(excludeWebResources);
                exclude.add("_context:_super");
                requestState.getIncluded().remove("_context:_super");
                LinkedHashSet<String> excludedResolved = Helpers.resolveExcluded(requestState.getCache(), requestState.getUrlStrategy(), new ArrayList<String>(exclude), requestState.getExcluded());
                requestState.getExcluded().clear();
                requestState.getExcluded().addAll(excludedResolved);
                return this;
            }

            public RequiredResources requirePage(String key) {
                RootPage rp = globals.getSnapshot().getRootPage(key);
                if (rp == null) {
                    throw new IllegalArgumentException("Root page '" + key + "' does not exist!");
                }
                requestState.getIncluded().addAll(rp.getWebResource().getDependencies());
                return this;
            }
        };
        this.requiredDataStub = new RequiredData(){

            public RequiredData requireData(String key, Jsonable content) {
                requestState.getIncludedData().put(key, content);
                return this;
            }

            public RequiredData requireData(String key, Number content) {
                requestState.getIncludedData().put(key, (Jsonable)new JsonableNumber(content));
                return this;
            }

            public RequiredData requireData(String key, String content) {
                requestState.getIncludedData().put(key, (Jsonable)new JsonableString(content));
                return this;
            }

            public RequiredData requireData(String key, Boolean content) {
                requestState.getIncludedData().put(key, (Jsonable)new JsonableBoolean(content));
                return this;
            }

            public RequiredData requireData(String key, CompletionStage<Jsonable> content) {
                requestState.getBigPipe().push(key, content);
                return this;
            }
        };
    }

    public AssembledResources assembled() {
        return this.assembledResourcesStub;
    }

    public RequiredResources resources() {
        return this.requiredResourcesStub;
    }

    public RequiredData data() {
        return this.requiredDataStub;
    }

    public WebResourceAssembler copy() {
        return new DefaultWebResourceAssembler(this.requestState.deepClone(), this.globals);
    }
}

